/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.core.compat.curios.CuriosProxy;
import cofh.lib.util.Utils;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.references.EnsorcReferences;
import cofh.thermal.core.inventory.container.storage.SatchelContainer;
import cofh.thermal.core.item.DivingArmorItem;
import cofh.thermal.core.item.SatchelItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="thermal")
public class TCoreCommonEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_208600_a((ITag)FluidTags.field_206959_a)) {
            boolean diveChest = player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof DivingArmorItem;
            if (!EnchantmentHelper.func_185287_i((LivingEntity)player) && diveChest) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
            boolean diveLegs = player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof DivingArmorItem;
            if (!player.func_233570_aj_() && diveLegs && Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.AIR_AFFINITY) <= 0) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
        } else if (player.func_70090_H()) {
            boolean diveLegs = player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof DivingArmorItem;
            if (!player.func_233570_aj_() && diveLegs && Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.AIR_AFFINITY) <= 0) {
                event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
            }
        }
    }

    @SubscribeEvent
    public static void handleEntityItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.field_71070_bA instanceof SatchelContainer || player.field_71070_bA instanceof IFilterOptions) {
            return;
        }
        PlayerInventory inventory = player.field_71071_by;
        boolean[] cancel = new boolean[]{false};
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
            cancel[0] = cancel[0] | SatchelItem.onItemPickup(event, stack);
        }
        CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack stack = c.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
                ItemStack satchelCopy = stack.func_77946_l();
                cancel[0] = cancel[0] | SatchelItem.onItemPickup(event, satchelCopy);
                c.setStackInSlot(i, satchelCopy);
            }
        });
        event.setCanceled(cancel[0]);
    }
}

