/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.NullFluidStorage;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.NullItemStorage;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceNullifierContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;

public class DeviceNullifierTile
extends DeviceTileBase {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Filter");
    protected ItemStorageCoFH nullSlot = new NullItemStorage(item -> this.filter.valid(item)).setEnabled(() -> this.isActive);
    protected ItemStorageCoFH[] binSlots;
    protected FluidStorageCoFH nullTank = new NullFluidStorage(64000, fluid -> this.filter.valid(fluid)).setEnabled(() -> this.isActive);

    public DeviceNullifierTile() {
        super(TCoreReferences.DEVICE_NULLIFIER_TILE);
        this.inventory.addSlot(this.nullSlot, StorageGroup.INPUT);
        this.binSlots = new ItemStorageCoFH[9];
        for (int i = 0; i < this.binSlots.length; ++i) {
            this.binSlots[i] = new ItemStorageCoFH(item -> this.filter.valid(item));
            this.inventory.addSlot(this.binSlots[i], StorageGroup.INTERNAL);
        }
        this.tankInv.addTank(this.nullTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    public boolean binHasItems() {
        for (ItemStorageCoFH slot : this.binSlots) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void emptyBin() {
        for (ItemStorageCoFH slot : this.binSlots) {
            slot.clear();
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceNullifierContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

