/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import net.minecraft.nbt.CompoundNBT;

public class MachineProperties
implements IRecipeCatalyst {
    protected float primaryMod = 1.0f;
    protected float secondaryMod = 1.0f;
    protected float energyMod = 1.0f;
    protected float xpMod = 1.0f;
    protected float catalystMod = 1.0f;
    protected float minOutputChance = 0.0f;

    public void resetAttributes() {
        this.primaryMod = 1.0f;
        this.secondaryMod = 1.0f;
        this.energyMod = 1.0f;
        this.xpMod = 1.0f;
        this.catalystMod = 1.0f;
        this.minOutputChance = 0.0f;
    }

    public void setAttributesFromAugment(CompoundNBT augmentData) {
        this.primaryMod += AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"MachinePri");
        this.secondaryMod += AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"MachineSec");
        this.energyMod *= AugmentableHelper.getAttributeModWithDefault((CompoundNBT)augmentData, (String)"MachineEnergy", (float)1.0f);
        this.xpMod *= AugmentableHelper.getAttributeModWithDefault((CompoundNBT)augmentData, (String)"MachineXp", (float)1.0f);
        this.catalystMod *= AugmentableHelper.getAttributeModWithDefault((CompoundNBT)augmentData, (String)"MachineCat", (float)1.0f);
        this.minOutputChance = Math.max(AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"MachineMin"), this.minOutputChance);
    }

    public void finalizeAttributes() {
        float scaleMin = Constants.AUG_SCALE_MIN;
        float scaleMax = Constants.AUG_SCALE_MAX;
        this.primaryMod = MathHelper.clamp((float)this.primaryMod, (float)scaleMin, (float)scaleMax);
        this.secondaryMod = MathHelper.clamp((float)this.secondaryMod, (float)scaleMin, (float)scaleMax);
        this.energyMod = MathHelper.clamp((float)this.energyMod, (float)scaleMin, (float)scaleMax);
        this.xpMod = MathHelper.clamp((float)this.xpMod, (float)scaleMin, (float)scaleMax);
        this.catalystMod = MathHelper.clamp((float)this.catalystMod, (float)scaleMin, (float)scaleMax);
    }

    @Override
    public final float getPrimaryMod() {
        return this.primaryMod;
    }

    @Override
    public final float getSecondaryMod() {
        return this.secondaryMod;
    }

    @Override
    public final float getEnergyMod() {
        return this.energyMod;
    }

    @Override
    public final float getXpMod() {
        return this.xpMod;
    }

    @Override
    public final float getMinOutputChance() {
        return this.minOutputChance;
    }

    @Override
    public final float getUseChance() {
        return this.catalystMod;
    }
}

