/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.totw_additions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.aurelj.totw_additions.TowersAdditionsMain;
import net.aurelj.totw_additions.structures.EndTowerStructure;
import net.aurelj.totw_additions.structures.NetherTowerStructure;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TOTWAStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"totw_additions");
    public static final RegistryObject<Structure<NoFeatureConfig>> END_TOWER = DEFERRED_REGISTRY_STRUCTURE.register("end_tower", () -> new EndTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_TOWER = DEFERRED_REGISTRY_STRUCTURE.register("nether_tower", () -> new NetherTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        TOTWAStructures.setupMapSpacingAndLand((Structure)END_TOWER.get(), new StructureSeparationSettings(TowersAdditionsMain.TOTWAConfig.endTowerSpacing.get().intValue(), TowersAdditionsMain.TOTWAConfig.endTowerSeparation.get().intValue(), 451526152), true);
        TOTWAStructures.setupMapSpacingAndLand((Structure)NETHER_TOWER.get(), new StructureSeparationSettings(TowersAdditionsMain.TOTWAConfig.netherTowerSpacing.get().intValue(), TowersAdditionsMain.TOTWAConfig.netherTowerSeparation.get().intValue(), 283716263), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

