/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.totw_additions;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import net.aurelj.totw_additions.TOTWAConfiguredStructures;
import net.aurelj.totw_additions.TOTWAStructures;
import net.aurelj.totw_additions.config.ConfigHelper;
import net.aurelj.totw_additions.config.TOTWAConfig;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="totw_additions")
public class TowersAdditionsMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "totw_additions";
    public static TOTWAConfig.TOTWAConfigValues TOTWAConfig = null;
    private static Method GETCODEC_METHOD;

    public TowersAdditionsMain() {
        TOTWAConfig = ConfigHelper.register(ModConfig.Type.COMMON, TOTWAConfig.TOTWAConfigValues::new, "towers-wild-additions-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TOTWAStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TOTWAStructures.setupStructures();
            TOTWAConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        if (types.contains(BiomeDictionary.Type.END) && TowersAdditionsMain.TOTWAConfig.endTowerGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> TOTWAConfiguredStructures.CONFIGURED_END_TOWER);
        }
        if (types.contains(BiomeDictionary.Type.NETHER) && TowersAdditionsMain.TOTWAConfig.netherTowerGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> TOTWAConfiguredStructures.CONFIGURED_NETHER_TOWER);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(TOTWAStructures.END_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TOTWAStructures.END_TOWER.get()));
            tempMap.putIfAbsent(TOTWAStructures.NETHER_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TOTWAStructures.END_TOWER.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

