/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.totw_additions.config;

import net.aurelj.totw_additions.config.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class TOTWAConfig {

    public static class TOTWAConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> endTowerGenerates;
        public ConfigHelper.ConfigValueListener<Integer> endTowerSpacing;
        public ConfigHelper.ConfigValueListener<Integer> endTowerSeparation;
        public ConfigHelper.ConfigValueListener<Boolean> endTowerWaystones;
        public ConfigHelper.ConfigValueListener<Boolean> netherTowerGenerates;
        public ConfigHelper.ConfigValueListener<Integer> netherTowerSpacing;
        public ConfigHelper.ConfigValueListener<Integer> netherTowerSeparation;
        public ConfigHelper.ConfigValueListener<Boolean> netherTowerWaystones;

        public TOTWAConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.comment("Basic configuration options\n\t    'Spacing' and 'Separation' values are useful if you want to tweak\n\t    the amount of structures that generate.\n\t    Keep in mind that spacing has to be higher than separation.\n\t    I.e.: endTowerSpacing = 1, endTowerSeparation = 0 will generate the 'End Tower' on every possible chunk.\n\t    'SpawnpointSeparation', on the other hand, is used to prevent structures from generating near x = 0, z = 0.\n\t    Further customization options are available through datapacks. This includes structure layout, loot, etc.\"");
            builder.push("Towers of the Wild: Additions - Configuration");
            builder.build();
            builder.push("End Tower Structure");
            this.endTowerGenerates = subscriber.subscribe(builder.comment("Whether End Towers generate on your worlds or not.").translation("totw_additions.config.end_tower.generates").define("endTowerGenerates", true));
            this.endTowerSpacing = subscriber.subscribe(builder.comment("Maximum distance between End Towers (in chunks).").translation("totw_additions.config.end_tower.spacing").defineInRange("endTowerSpacing", 20, 0, 1000000));
            this.endTowerSeparation = subscriber.subscribe(builder.comment("Minimum distance between End Towers (in chunks).").translation("totw_additions.config.end_tower.separation").defineInRange("endTowerSeparation", 10, 0, 1000000));
            this.endTowerWaystones = subscriber.subscribe(builder.comment("Whether End Towers should integrate Waystones mod or not.").translation("totw_additions.config.end_tower.waystones").define("endTowerWaystones", true));
            builder.pop();
            builder.push("Nether Tower Structure");
            this.netherTowerGenerates = subscriber.subscribe(builder.comment("Whether Nether Towers generate on your worlds or not.").translation("totw_additions.config.nether_tower.generates").define("netherTowerGenerates", true));
            this.netherTowerSpacing = subscriber.subscribe(builder.comment("Maximum distance between Nether Towers (in chunks).").translation("totw_additions.config.nether_tower.spacing").defineInRange("netherTowerSpacing", 15, 0, 1000000));
            this.netherTowerSeparation = subscriber.subscribe(builder.comment("Minimum distance between Nether Towers (in chunks).").translation("totw_additions.config.nether_tower.separation").defineInRange("netherTowerSeparation", 5, 0, 1000000));
            this.netherTowerWaystones = subscriber.subscribe(builder.comment("Whether Nether Towers should integrate Waystones mod or not.").translation("totw_additions.config.nether_tower.waystones").define("netherTowerWaystones", true));
            builder.pop();
        }
    }
}

