/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.events;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.register.TowerStructureFeaturesRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TowersOfTheWildEventSubscriber {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoaded(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        Biome.Category category = event.getCategory();
        boolean isPrimalWinterLoaded = ModList.get().isLoaded("primalwinter");
        if (!isPrimalWinterLoaded) {
            if (category.equals((Object)Biome.Category.JUNGLE)) {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.JUNGLE_TOWER_FEATURE);
                return;
            }
            if (category.equals((Object)Biome.Category.ICY)) {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.ICE_TOWER_FEATURE);
                return;
            }
        } else if (!category.equals((Object)Biome.Category.OCEAN)) {
            event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.ICE_TOWER_FEATURE);
            return;
        }
        if (TowersOfTheWildConfig.spawnOceanTowers) {
            if (name.toString().equals("minecraft:deep_lukewarm_ocean") || name.toString().equals("minecraft:deep_warm_ocean")) {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.OCEAN_WARM_TOWER_FEATURE);
                return;
            }
            if (category.equals((Object)Biome.Category.OCEAN) && name.toString().contains("deep")) {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.OCEAN_TOWER_FEATURE);
                return;
            }
        }
        if (!(category.equals((Object)Biome.Category.OCEAN) || category.equals((Object)Biome.Category.NETHER) || category.equals((Object)Biome.Category.THEEND) || TowersOfTheWildConfig.allModBiomesBlackList.contains(name.func_110624_b()) || TowersOfTheWildConfig.biomeBlackList.contains(name.toString()))) {
            event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.TOWER_FEATURE);
            if (category.equals((Object)Biome.Category.TAIGA) || category.equals((Object)Biome.Category.EXTREME_HILLS) || category.equals((Object)Biome.Category.SAVANNA) || category.equals((Object)Biome.Category.PLAINS) || category.equals((Object)Biome.Category.FOREST)) {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.DERELICT_GRASS_TOWER_FEATURE);
            } else {
                event.getGeneration().func_242516_a(TowerStructureFeaturesRegistry.DERELICT_TOWER_FEATURE);
            }
        }
    }
}

