/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.structures;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.register.TowerStructuresRegistry;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.fml.RegistryObject;

public abstract class AbstractTowerStructure
extends Structure<NoFeatureConfig> {
    public AbstractTowerStructure(Codec<NoFeatureConfig> p_i231997_1_) {
        super(p_i231997_1_);
    }

    public int getDistance() {
        return TowersOfTheWildConfig.rarity;
    }

    public int getSeparation() {
        return TowersOfTheWildConfig.rarity / 3;
    }

    public abstract int getSeedModifier();

    public abstract int getSize();

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider biomeProvider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, NoFeatureConfig config) {
        Iterator iterator;
        if (this.isTerrainFlat(generator, chunkX, chunkZ) && !this.alreadyIsTower(generator, this, seed, rand, chunkX, chunkZ) && (iterator = biomeProvider.func_225530_a_(chunkX * 16 + this.getSize() / 2, generator.func_230356_f_(), chunkZ * 16 + this.getSize() / 2, this.getSize() * 16).iterator()).hasNext()) {
            Biome biome1 = (Biome)iterator.next();
            return biome1.getRegistryName() == null || !TowersOfTheWildConfig.biomeBlackList.contains(biome1.getRegistryName().toString()) && !TowersOfTheWildConfig.allModBiomesBlackList.contains(biome1.getRegistryName().func_110624_b());
        }
        return false;
    }

    protected boolean alreadyIsTower(ChunkGenerator generator, AbstractTowerStructure structure, long seed, SharedSeedRandom rand, int chunkX, int chunkZ) {
        for (int k = chunkX - this.getSeparation() / 2; k <= chunkX + this.getSeparation() / 2; ++k) {
            for (int l = chunkZ - this.getSeparation() / 2; l <= chunkZ + this.getSeparation() / 2; ++l) {
                for (RegistryObject ro : TowerStructuresRegistry.STRUCTURE_FEATURES.getEntries()) {
                    Structure otherStructure = (Structure)ro.get();
                    if (((Object)((Object)structure)).equals(otherStructure)) continue;
                    ChunkPos otherStructurePos = otherStructure.func_236392_a_(Objects.requireNonNull(generator.func_235957_b_().func_236197_a_(otherStructure)), seed, rand, k, l);
                    if (k != otherStructurePos.field_77276_a || l != otherStructurePos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isTerrainFlat(ChunkGenerator generator, int chunkX, int chunkZ) {
        int offset = this.getSize();
        int xStart = chunkX * 16;
        int zStart = chunkZ * 16;
        int i1 = generator.func_222529_a(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222529_a(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222529_a(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222529_a(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
        return Math.abs(maxHeight - minHeight) <= 4;
    }

    public abstract class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int p_i225876_2_, int p_i225876_3_, MutableBoundingBox boundingBox, int p_i225876_5_, long p_i225876_6_) {
            super(structure, p_i225876_2_, p_i225876_3_, boundingBox, p_i225876_5_, p_i225876_6_);
        }
    }
}

