/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.CritterBlock;
import twilightforest.block.GiantBlock;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.data.BlockTagGenerator;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.CharmEffectEntity;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.TFEntities;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.item.PhantomArmorItem;
import twilightforest.item.TFItems;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.EnforceProgressionStatusPacket;
import twilightforest.network.SetSkylightEnabledPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;
import twilightforest.potions.TFPotions;
import twilightforest.tileentity.KeepsakeCasketTileEntity;
import twilightforest.util.TFItemStackUtils;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFEventListener {
    private static final ImmutableSet<String> SHIELD_DAMAGE_BLACKLIST = ImmutableSet.of((Object)"inWall", (Object)"cramming", (Object)"drown", (Object)"starve", (Object)"fall", (Object)"flyIntoWall", (Object[])new String[]{"outOfWorld", "fallingBlock"});
    private static final Map<UUID, PlayerInventory> playerKeepsMap = new HashMap<UUID, PlayerInventory>();
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static boolean casketExpiration = false;
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";
    private static boolean globalParry = !ModList.get().isLoaded("parry");

    @SubscribeEvent
    public static void addReach(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if ((item == TFItems.giant_pickaxe.get() || item == TFItems.giant_sword.get()) && event.getSlotType() == EquipmentSlotType.MAINHAND) {
            event.addModifier((Attribute)ForgeMod.REACH_DISTANCE.get(), new AttributeModifier(TFItems.GIANT_REACH_MODIFIER, "Tool modifier", 2.5, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        PlayerEntity player = event.getPlayer();
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_196662_n) && itemStack.func_190916_E() == 64 && TFEventListener.doesCraftMatrixHaveGiantLog(event.getInventory())) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196662_n, 64));
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196662_n, 64));
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196662_n, 64));
        }
    }

    private static boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        Item giantLogItem = Item.func_150898_a((Block)((Block)TFBlocks.giant_log.get()));
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_77973_b() != giantLogItem) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        ItemStack stack;
        Block block;
        PlayerEntity player;
        LivingEntity living = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        String damageType = damageSource.func_76355_l();
        Entity trueSource = damageSource.func_76346_g();
        if (living instanceof PlayerEntity && damageType.equals("mob") && trueSource != null) {
            player = (PlayerEntity)living;
            int fireLevel = TFEnchantment.getFieryAuraLevel(player.field_71071_by, damageSource);
            if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                trueSource.func_70015_d(fireLevel / 2);
            }
        }
        if (living instanceof PlayerEntity && damageType.equals("mob") && trueSource instanceof LivingEntity) {
            player = (PlayerEntity)living;
            int chillLevel = TFEnchantment.getChillAuraLevel(player.field_71071_by, damageSource);
            if (chillLevel > 0) {
                ((LivingEntity)trueSource).func_195064_c(new EffectInstance((Effect)TFPotions.frosty.get(), chillLevel * 5 + 5, chillLevel));
            }
        }
        if (damageType.equals("arrow") && trueSource instanceof PlayerEntity && ((player = (PlayerEntity)trueSource).func_184614_ca().func_77973_b() == TFItems.triple_bow.get() || player.func_184592_cb().func_77973_b() == TFItems.triple_bow.get())) {
            living.field_70172_ad = 0;
        }
        if (damageSource != DamageSource.field_76379_h && damageSource != DamageSource.field_76369_e && damageSource != DamageSource.field_220302_v && (block = Block.func_149634_a((Item)(stack = living.func_184582_a(EquipmentSlotType.HEAD)).func_77973_b())) instanceof CritterBlock) {
            CritterBlock poorBug = (CritterBlock)block;
            living.func_184201_a(EquipmentSlotType.HEAD, poorBug.getSquishResult());
            living.field_70170_p.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), TFSounds.BUG_SQUISH, living.func_184176_by(), 1.0f, 1.0f);
        }
        if (living instanceof PlayerEntity && TFEventListener.isRidingUnfriendly(living) && damageSource == DamageSource.field_76368_d) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyDeathItems(LivingDeathEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K || !(living instanceof PlayerEntity) || living instanceof FakePlayer) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        if (TFEventListener.charmOfLife(player)) {
            event.setCanceled(true);
        } else if (!living.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            TFEventListener.charmOfKeeping(player);
            TFEventListener.keepsakeCasket(player);
        }
    }

    private static void keepsakeCasket(PlayerEntity player) {
        boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, ((KeepsakeCasketBlock)TFBlocks.keepsake_casket.get()).func_199767_j());
        if (casketConsumed) {
            World world = player.func_130014_f_();
            BlockPos.Mutable pos = player.func_233580_cy_().func_239590_i_();
            if (pos.func_177956_o() < 2) {
                pos.func_185336_p(2);
            } else {
                int logicalHeight = player.func_130014_f_().func_230315_m_().func_241513_m_();
                if (pos.func_177956_o() > logicalHeight) {
                    pos.func_185336_p(logicalHeight - 1);
                }
            }
            BlockPos immutablePos = pos.func_185334_h();
            FluidState fluidState = world.func_204610_c(immutablePos);
            if (world.func_175656_a(immutablePos, (BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.keepsake_casket.get()).func_176223_P().func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.func_206886_c())))).func_206870_a((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(TFItemStackUtils.damage)))) {
                TileEntity te = world.func_175625_s(immutablePos);
                if (te instanceof KeepsakeCasketTileEntity) {
                    KeepsakeCasketTileEntity casket = (KeepsakeCasketTileEntity)te;
                    casket.playeruuid = (Boolean)TFConfig.COMMON_CONFIG.casketUUIDLocking.get() != false ? player.func_146103_bH().getId() : null;
                    String modifiedName = player.func_200200_C_().getString().length() > 12 ? player.func_200200_C_().getString().substring(0, 12) : player.func_200200_C_().getString();
                    casket.name = player.func_200200_C_().getString();
                    casket.casketname = modifiedName;
                    casket.func_213903_a((ITextComponent)new StringTextComponent(modifiedName + "'s " + (world.field_73012_v.nextInt(10000) == 0 ? "Costco Casket" : casket.func_145748_c_().getString())));
                    int damage = (Integer)world.func_180495_p(immutablePos).func_177229_b((Property)KeepsakeCasketBlock.BREAKAGE);
                    if (world.field_73012_v.nextFloat() <= 0.15f) {
                        if (damage >= 2) {
                            player.field_71071_by.func_70436_m();
                            world.func_175656_a(immutablePos, Blocks.field_150350_a.func_176223_P());
                            casketExpiration = true;
                            TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, alerting the player and dropping extra items", (Object)player.func_200200_C_().getString());
                        } else {
                            world.func_175656_a(immutablePos, (BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.keepsake_casket.get()).func_176223_P().func_206870_a(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.func_206886_c())))).func_206870_a((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage)));
                            TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.func_200200_C_().getString());
                        }
                    }
                    int casketCapacity = casket.func_70302_i_();
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>(casketCapacity);
                    NonNullList filler = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortArmorForCasket(player));
                    player.field_71071_by.field_70460_b.clear();
                    list.addAll((Collection<ItemStack>)filler);
                    list.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
                    player.field_71071_by.field_184439_c.clear();
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortInvForCasket(player));
                    player.field_71071_by.field_70462_a.clear();
                    casket.func_199721_a((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])list.toArray(new ItemStack[casketCapacity])));
                }
            } else {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at " + pos.toString());
            }
        }
    }

    @SubscribeEvent
    public static void onCasketBreak(BlockEvent.BreakEvent event) {
        Block block = event.getState().func_177230_c();
        PlayerEntity player = event.getPlayer();
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (block == TFBlocks.keepsake_casket.get()) {
            UUID checker;
            if (te instanceof KeepsakeCasketTileEntity) {
                KeepsakeCasketTileEntity casket = (KeepsakeCasketTileEntity)te;
                checker = casket.playeruuid;
            } else {
                checker = null;
            }
            if (!(checker == null || ((KeepsakeCasketTileEntity)te).func_191420_l() || player.func_211513_k(3) && player.func_146103_bH().getId().equals(checker))) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean charmOfLife(PlayerEntity player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.charm_of_life_2.get());
        boolean bl = charm1 = !charm2 && TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.charm_of_life_1.get());
        if (charm2 || charm1) {
            if (charm1) {
                player.func_70606_j(8.0f);
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 0));
            }
            if (charm2) {
                player.func_70606_j((float)player.func_110148_a(Attributes.field_233818_a_).func_111125_b());
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, 3));
                player.func_195064_c(new EffectInstance(Effects.field_76429_m, 600, 0));
                player.func_195064_c(new EffectInstance(Effects.field_76426_n, 600, 0));
            }
            CharmEffectEntity effect = new CharmEffectEntity(TFEntities.charm_effect, player.field_70170_p, (LivingEntity)player, charm1 ? (Item)TFItems.charm_of_life_1.get() : (Item)TFItems.charm_of_life_2.get());
            player.field_70170_p.func_217376_c((Entity)effect);
            CharmEffectEntity effect2 = new CharmEffectEntity(TFEntities.charm_effect, player.field_70170_p, (LivingEntity)player, charm1 ? (Item)TFItems.charm_of_life_1.get() : (Item)TFItems.charm_of_life_2.get());
            effect2.offset = (float)Math.PI;
            player.field_70170_p.func_217376_c((Entity)effect2);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), TFSounds.CHARM_LIFE, player.func_184176_by(), 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private static void charmOfKeeping(PlayerEntity player) {
        int i;
        TFEventListener.dropStoredItems(player);
        boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.charm_of_keeping_3.get());
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.charm_of_keeping_2.get());
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.charm_of_keeping_1.get());
        PlayerInventory keepInventory = new PlayerInventory(null);
        UUID playerUUID = player.func_110124_au();
        if (tier1) {
            TFEventListener.keepAllArmor(player, keepInventory);
            TFEventListener.keepOffHand(player, keepInventory);
        }
        if (tier3) {
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack((IItemProvider)TFItems.charm_of_keeping_3.get()));
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack((IItemProvider)TFItems.charm_of_keeping_2.get()));
        } else if (tier1) {
            i = player.field_71071_by.field_70461_c;
            if (PlayerInventory.func_184435_e((int)i)) {
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            keepInventory.func_70437_b(new ItemStack((IItemProvider)TFItems.charm_of_keeping_1.get()));
        }
        for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() == TFItems.tower_key.get()) {
                keepInventory.field_70462_a.set(i, (Object)stack.func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            if (!(stack.func_77973_b() instanceof PhantomArmorItem)) continue;
            keepInventory.field_70462_a.set(i, (Object)stack.func_77946_l());
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!(armor.func_77973_b() instanceof PhantomArmorItem)) continue;
            keepInventory.field_70460_b.set(i, (Object)armor.func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
        playerKeepsMap.put(playerUUID, keepInventory);
    }

    private static void keepAllArmor(PlayerEntity player, PlayerInventory keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            keepInventory.field_70460_b.set(i, (Object)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private static void keepOffHand(PlayerEntity player, PlayerInventory keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
            keepInventory.field_184439_c.set(i, (Object)((ItemStack)player.field_71071_by.field_184439_c.get(i)).func_77946_l());
            player.field_71071_by.field_184439_c.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            TFEventListener.updateCapabilities((ServerPlayerEntity)event.getPlayer(), (Entity)event.getPlayer());
        } else {
            if (casketExpiration) {
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("block.twilightforest.casket.broken").func_240699_a_(TextFormatting.DARK_RED), event.getPlayer().func_110124_au());
            }
            TFEventListener.returnStoredItems(event.getPlayer());
        }
    }

    private static void returnStoredItems(PlayerEntity player) {
        PlayerInventory keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            ItemStack existing;
            ItemStack kept;
            int i;
            TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.func_200200_C_().getString(), (Object)player.func_110124_au());
            NonNullList displaced = NonNullList.func_191196_a();
            for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70460_b.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70460_b.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
                kept = (ItemStack)keepInventory.field_184439_c.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_184439_c.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70462_a.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70462_a.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (ItemStack extra : displaced) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extra);
            }
            if (!keepInventory.func_70445_o().func_190926_b()) {
                CharmEffectEntity effect = new CharmEffectEntity(TFEntities.charm_effect, player.field_70170_p, (LivingEntity)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_217376_c((Entity)effect);
                CharmEffectEntity effect2 = new CharmEffectEntity(TFEntities.charm_effect, player.field_70170_p, (LivingEntity)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_217376_c((Entity)effect2);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), TFSounds.CHARM_KEEP, player.func_184176_by(), 1.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TFEventListener.dropStoredItems(event.getPlayer());
    }

    private static void dropStoredItems(PlayerEntity player) {
        PlayerInventory keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            TwilightForestMod.LOGGER.warn("Dropping inventory items previously held in reserve for player {} ({})", (Object)player.func_200200_C_().getString(), (Object)player.func_110124_au());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        living.getCapability(CapabilityList.SHIELDS).ifPresent(IShieldCapability::update);
        if (living instanceof PlayerEntity && living.func_225608_bj_() && TFEventListener.isRidingUnfriendly(living)) {
            living.func_226284_e_(false);
        }
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.func_184218_aH() && entity.func_184187_bx() instanceof IHostileMount;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!(event.getWorld() instanceof World) || ((World)event.getWorld()).field_72995_K) {
            return;
        }
        World world = (World)event.getWorld();
        if (TFEventListener.isBlockProtectedFromBreaking(world, pos) && TFEventListener.isAreaProtected(world, player, pos)) {
            event.setCanceled(true);
        } else if (!isBreakingWithGiantPick && TFEventListener.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            Item cobbleItem = Blocks.field_150347_e.func_199767_j();
            boolean bl = allCobble = state.func_177230_c().func_199767_j() == cobbleItem;
            if (allCobble) {
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    BlockState stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = world.func_180495_p(dPos)).func_177230_c().func_199767_j() == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.field_71075_bZ.field_75098_d) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state != world.func_180495_p(dPos)) continue;
                    playerMP.field_71134_c.func_180237_b(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    private static boolean canHarvestWithGiantPick(PlayerEntity player, BlockState state) {
        ItemStack heldStack = player.func_184614_ca();
        Item heldItem = heldStack.func_77973_b();
        return heldItem == TFItems.giant_pickaxe.get() && heldItem.canHarvestBlock(heldStack, state);
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && TFEventListener.isBlockProtectedFromInteraction(world, event.getPos()) && TFEventListener.isAreaProtected(world, player, event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static boolean isBlockProtectedFromInteraction(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block.func_203417_a(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_177230_c().getRegistryName().func_110623_a().contains("grave") || !world.func_180495_p(pos).func_177230_c().func_235332_a_((Block)TFBlocks.keepsake_casket.get());
    }

    private static boolean isAreaProtected(World world, PlayerEntity player, BlockPos pos) {
        TFFeature nearbyFeature;
        StructureStart<?> structure;
        Optional<StructureStart<?>> struct;
        if (player.field_71075_bZ.field_75098_d || !TFGenerationSettings.isProgressionEnforced(world) || player instanceof FakePlayer) {
            return false;
        }
        ChunkGeneratorTwilightBase chunkGenerator = TFGenerationSettings.getChunkGenerator(world);
        if (chunkGenerator != null && (struct = TFGenerationSettings.locateTFStructureInRange((ISeedReader)((ServerWorld)world), pos, 0)).isPresent() && (structure = struct.get()).func_75071_a().func_175898_b((Vector3i)pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), (ISeedReader)((ServerWorld)world))).doesPlayerHaveRequiredAdvancements(player)) {
            if (nearbyFeature == TFFeature.KNIGHT_STRONGHOLD && pos.func_177956_o() >= 33) {
                return false;
            }
            MutableBoundingBox bb = structure.func_75071_a();
            TFEventListener.sendAreaProtectionPacket(world, pos, bb);
            nearbyFeature.trySpawnHintMonster(world, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(World world, BlockPos pos, MutableBoundingBox sbb) {
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0, world.func_234923_W_());
        TFPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)new AreaProtectionPacket(sbb, pos));
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof IMob && event.getSource().func_76346_g() instanceof PlayerEntity && TFEventListener.isAreaProtected(living.field_70170_p, (PlayerEntity)event.getSource().func_76346_g(), new BlockPos((Vector3i)living.func_233580_cy_()))) {
            event.setCanceled(true);
            return;
        }
        if (!living.field_70170_p.field_72995_K && !SHIELD_DAMAGE_BLACKLIST.contains((Object)event.getSource().field_76373_n)) {
            living.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            TFEventListener.sendEnforcedProgressionStatus((ServerPlayerEntity)event.getPlayer(), TFGenerationSettings.isProgressionEnforced(event.getPlayer().field_70170_p));
            TFEventListener.updateCapabilities((ServerPlayerEntity)event.getPlayer(), (Entity)event.getPlayer());
            TFEventListener.banishNewbieToTwilightZone(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            if (event.getTo().func_240901_a_().toString().equals(TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get())) {
                TFEventListener.sendEnforcedProgressionStatus((ServerPlayerEntity)event.getPlayer(), TFGenerationSettings.isProgressionEnforced(event.getPlayer().field_70170_p));
            }
            TFEventListener.updateCapabilities((ServerPlayerEntity)event.getPlayer(), (Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        TFEventListener.updateCapabilities((ServerPlayerEntity)event.getPlayer(), event.getTarget());
    }

    private static void updateCapabilities(ServerPlayerEntity player, Entity entity) {
        entity.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateShieldPacket(entity, (IShieldCapability)cap));
            }
        });
    }

    private static void sendEnforcedProgressionStatus(ServerPlayerEntity player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnforceProgressionStatusPacket(isEnforced));
    }

    private static void sendSkylightEnabled(ServerPlayerEntity player, boolean skylightEnabled) {
        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetSkylightEnabledPacket(skylightEnabled));
    }

    @SubscribeEvent
    public static void onClientConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && world instanceof World && !((GameRules.BooleanValue)((World)world).func_82736_K().func_223585_a(TwilightForestMod.ENFORCED_PROGRESSION_RULE)).func_223572_a()) {
            TwilightForestMod.LOGGER.info("Loaded a world with the {} game rule not defined. Defining it.", TwilightForestMod.ENFORCED_PROGRESSION_RULE);
            ((GameRules.BooleanValue)((World)world).func_82736_K().func_223585_a(TwilightForestMod.ENFORCED_PROGRESSION_RULE)).func_223570_a(((Boolean)TFConfig.COMMON_CONFIG.progressionRuleDefault.get()).booleanValue(), ((World)world).func_73046_m());
        }
    }

    private static void banishNewbieToTwilightZone(PlayerEntity player) {
        CompoundNBT tagCompound = player.getPersistentData();
        CompoundNBT playerData = tagCompound.func_74775_l("PlayerPersisted");
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.func_74767_n(NBT_TAG_TWILIGHT);
        playerData.func_74757_a(NBT_TAG_TWILIGHT, true);
        tagCompound.func_218657_a("PlayerPersisted", (INBT)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendPlayer((Entity)player, true);
        }
    }

    @SubscribeEvent
    public static void onAdvancementGet(AdvancementEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            TFAdvancements.ADVANCEMENT_UNLOCKED.trigger((ServerPlayerEntity)player, event.getAdvancement());
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof ServerPlayerEntity) {
            TFAdvancements.ARMOR_CHANGED.trigger((ServerPlayerEntity)living, event.getFrom(), event.getTo());
        }
    }

    @SubscribeEvent
    public static void arrowParry(ProjectileImpactEvent.Arrow event) {
        final AbstractArrowEntity projectile = event.getArrow();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && event.getRayTraceResult() instanceof EntityRayTraceResult) {
            LivingEntity entityBlocking;
            Entity entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (event.getEntity() != null && entity instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).func_184583_d(new DamageSource("parry_this"){

                public Vector3d func_188404_v() {
                    return projectile.func_213303_ch();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicksArrow.get()) {
                Vector3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.func_212361_a((Entity)entityBlocking);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void fireballParry(ProjectileImpactEvent.Fireball event) {
        final DamagingProjectileEntity projectile = event.getFireball();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && event.getRayTraceResult() instanceof EntityRayTraceResult) {
            LivingEntity entityBlocking;
            Entity entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (event.getEntity() != null && entity instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).func_184583_d(new DamageSource("parry_this"){

                public Vector3d func_188404_v() {
                    return projectile.func_213303_ch();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicksFireball.get()) {
                Vector3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_213317_d(new Vector3d(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c));
                projectile.field_70232_b = projectile.func_213322_ci().func_82615_a() * 0.1;
                projectile.field_70233_c = projectile.func_213322_ci().func_82617_b() * 0.1;
                projectile.field_70230_d = projectile.func_213322_ci().func_82616_c() * 0.1;
                projectile.func_212361_a((Entity)entityBlocking);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent.Throwable event) {
        final ThrowableEntity projectile = event.getThrowable();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && event.getRayTraceResult() instanceof EntityRayTraceResult) {
            LivingEntity entityBlocking;
            Entity entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (event.getEntity() != null && entity instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).func_184583_d(new DamageSource("parry_this"){

                public Vector3d func_188404_v() {
                    return projectile.func_213303_ch();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicksThrowable.get()) {
                Vector3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.func_212361_a((Entity)entityBlocking);
                event.setCanceled(true);
            }
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ManipulateDrops> {
        public ManipulateDrops read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new ManipulateDrops(conditionsIn);
        }

        public JsonObject write(ManipulateDrops instance) {
            return null;
        }
    }

    public static class ManipulateDrops
    extends LootModifier {
        protected ManipulateDrops(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
            boolean flag = false;
            if (shouldMakeGiantCobble && generatedLoot.size() > 0 && generatedLoot.get(0).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
                generatedLoot.remove(0);
                if (amountOfCobbleToReplace == 64) {
                    newLoot.add(new ItemStack((IItemProvider)TFBlocks.giant_cobblestone.get()));
                    flag = true;
                }
                amountOfCobbleToReplace--;
                if (amountOfCobbleToReplace <= 0) {
                    shouldMakeGiantCobble = false;
                }
            }
            return flag ? newLoot : generatedLoot;
        }
    }
}

