/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.TFSounds;
import twilightforest.client.particle.TFParticleType;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFGenerationSettings;

public class CastleDoorBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.func_177716_a((String)"vanish");
    private static final VoxelShape REAPPEARING_BB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625));

    public CastleDoorBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)VANISHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE, VANISHED});
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)VANISHED) != false ? VoxelShapes.func_197880_a() : super.func_220071_b(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)VANISHED) != false ? REAPPEARING_BB : super.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.onActivation(world, pos, state);
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!(block instanceof CastleDoorBlock) && world.func_175640_z(pos)) {
            this.onActivation(world, pos, state);
        }
    }

    private ActionResultType onActivation(World world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)VANISHED)).booleanValue() || ((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            return ActionResultType.FAIL;
        }
        if (CastleDoorBlock.isBlockLocked(world, pos)) {
            world.func_184133_a(null, pos, TFSounds.DOOR_ACTIVATED, SoundCategory.BLOCKS, 1.0f, 0.3f);
            return ActionResultType.PASS;
        }
        CastleDoorBlock.changeToActiveBlock(world, pos, state);
        return ActionResultType.SUCCESS;
    }

    private static void changeToActiveBlock(World world, BlockPos pos, BlockState originState) {
        if (originState.func_177230_c() instanceof CastleDoorBlock) {
            world.func_175656_a(pos, (BlockState)originState.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
        world.func_205220_G_().func_205360_a(pos, (Object)originState.func_177230_c(), 2 + world.field_73012_v.nextInt(5));
    }

    private static boolean isBlockLocked(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            ChunkGeneratorTwilightBase chunkGeneratorTwilightBase = TFGenerationSettings.getChunkGenerator(world);
        }
        return false;
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)VANISHED)).booleanValue()) {
            if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)VANISHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                CastleDoorBlock.changeToActiveBlock((World)world, pos, state);
            }
            CastleDoorBlock.playReappearSound((World)world, pos);
        } else if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)VANISHED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            world.func_205220_G_().func_205360_a(pos, (Object)this, 80);
            CastleDoorBlock.playVanishSound((World)world, pos);
            CastleDoorBlock.vanishParticles((World)world, pos);
            for (Direction e : Direction.values()) {
                CastleDoorBlock.checkAndActivateCastleDoor((World)world, pos.func_177972_a(e));
            }
        }
    }

    private static void playVanishSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, TFSounds.DOOR_VANISH, SoundCategory.BLOCKS, 0.125f, world.field_73012_v.nextFloat() * 0.25f + 1.75f);
    }

    private static void playReappearSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, TFSounds.DOOR_REAPPEAR, SoundCategory.BLOCKS, 0.125f, world.field_73012_v.nextFloat() * 0.25f + 1.25f);
    }

    public static void checkAndActivateCastleDoor(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof CastleDoorBlock && !((Boolean)state.func_177229_b((Property)VANISHED)).booleanValue() && !((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() && !CastleDoorBlock.isBlockLocked(world, pos)) {
            CastleDoorBlock.changeToActiveBlock(world, pos, state);
        }
    }

    private static void vanishParticles(World world, BlockPos pos) {
        Random rand = world.func_201674_k();
        if (world instanceof ServerWorld) {
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dz = 0; dz < 4; ++dz) {
                        double x = (double)pos.func_177958_n() + ((double)dx + 0.5) / 4.0;
                        double y = (double)pos.func_177956_o() + ((double)dy + 0.5) / 4.0;
                        double z = (double)pos.func_177952_p() + ((double)dz + 0.5) / 4.0;
                        double speed = rand.nextGaussian() * 0.2;
                        ((ServerWorld)world).func_195598_a((IParticleData)TFParticleType.ANNIHILATE.get(), x, y, z, 1, 0.0, 0.0, 0.0, speed);
                    }
                }
            }
        }
    }
}

