/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class ConnectableRotatedPillarBlock
extends RotatedPillarBlock {
    private static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    private static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    private static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    private static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    private static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    final double boundingBoxWidthLower;
    final double boundingBoxWidthUpper;
    private final double boundingBoxHeightLower;
    private final double boundingBoxHeightUpper;

    ConnectableRotatedPillarBlock(AbstractBlock.Properties props, double size) {
        this(props, size, size);
    }

    ConnectableRotatedPillarBlock(AbstractBlock.Properties props, double width, double height) {
        super(props.func_226896_b_());
        if (width >= 16.0) {
            this.boundingBoxWidthLower = 0.0;
            this.boundingBoxWidthUpper = 16.0;
        } else {
            this.boundingBoxWidthLower = 8.0 - width / 2.0;
            this.boundingBoxWidthUpper = 16.0 - this.boundingBoxWidthLower;
        }
        if (height >= 16.0) {
            this.boundingBoxHeightLower = 0.0;
            this.boundingBoxHeightUpper = 16.0;
        } else {
            this.boundingBoxHeightLower = 8.0 - height / 2.0;
            this.boundingBoxHeightUpper = 16.0 - this.boundingBoxHeightLower;
        }
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176298_M, (Comparable)Direction.Axis.Y)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.func_206870_a((Property)SixWayBlock.field_196491_B.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, facing.func_176734_d()))));
    }

    public boolean canConnectTo(BlockState state, boolean solidSide) {
        Block block = state.func_177230_c();
        return !ConnectableRotatedPillarBlock.func_220073_a((Block)block) && solidSide;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177968_d();
        BlockPos blockpos3 = blockpos.func_177976_e();
        BlockPos blockpos4 = blockpos.func_177974_f();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)context.func_196000_l().func_176740_k())).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate, blockstate.func_224755_d((IBlockReader)iblockreader, blockpos1, Direction.SOUTH))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate1, blockstate1.func_224755_d((IBlockReader)iblockreader, blockpos2, Direction.NORTH))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate2, blockstate2.func_224755_d((IBlockReader)iblockreader, blockpos3, Direction.EAST))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate3, blockstate3.func_224755_d((IBlockReader)iblockreader, blockpos4, Direction.WEST))));
    }

    protected AxisAlignedBB getSidedAABBStraight(Direction facing, Direction.Axis axis) {
        return this.makeQuickAABB(facing == Direction.EAST ? 16.0 : (axis == Direction.Axis.X ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.UP ? 16.0 : (axis == Direction.Axis.Y ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.SOUTH ? 16.0 : (axis == Direction.Axis.Z ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.WEST ? 0.0 : (axis == Direction.Axis.X ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper), facing == Direction.DOWN ? 0.0 : (axis == Direction.Axis.Y ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper), facing == Direction.NORTH ? 0.0 : (axis == Direction.Axis.Z ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b((Property)field_176298_M)) {
            case X: {
                return ConnectableRotatedPillarBlock.func_208617_a((double)0.0, (double)((Boolean)state.func_177229_b((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.func_177229_b((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)16.0, (double)((Boolean)state.func_177229_b((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.func_177229_b((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper));
            }
            case Z: {
                return ConnectableRotatedPillarBlock.func_208617_a((double)((Boolean)state.func_177229_b((Property)EAST) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.func_177229_b((Property)SOUTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.func_177229_b((Property)WEST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.func_177229_b((Property)NORTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0);
            }
        }
        return ConnectableRotatedPillarBlock.func_208617_a((double)((Boolean)state.func_177229_b((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.func_177229_b((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.func_177229_b((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0, (double)((Boolean)state.func_177229_b((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper));
    }

    protected AxisAlignedBB makeQuickAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }
}

