/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.ArrayUtils;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.entity.boss.LichEntity;

public class ShieldLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public static final ModelResourceLocation LOC = new ModelResourceLocation(new ResourceLocation("twilightforest", "shield"), "inventory");
    private static final Direction[] DIRS = (Direction[])ArrayUtils.add((Object[])Direction.values(), null);
    private static final Random RAND = new Random();

    public ShieldLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    private int getShieldCount(T entity) {
        return entity instanceof LichEntity ? ((LichEntity)((Object)entity)).getShieldStrength() : entity.getCapability(CapabilityList.SHIELDS).map(IShieldCapability::shieldsLeft).orElse(0).intValue();
    }

    private void renderShields(MatrixStack stack, IRenderTypeBuffer buffer, T entity, float partialTicks) {
        float age = (float)((LivingEntity)entity).field_70173_aa + partialTicks;
        float rotateAngleY = age / 5.0f;
        float rotateAngleX = MathHelper.func_76126_a((float)(age / 5.0f)) / 4.0f;
        float rotateAngleZ = MathHelper.func_76134_b((float)(age / 5.0f)) / 4.0f;
        int count = this.getShieldCount(entity);
        for (int c = 0; c < count; ++c) {
            stack.func_227860_a_();
            stack.func_227861_a_(-0.5, 0.5, -0.5);
            stack.func_227862_a_(1.0f, -1.0f, 1.0f);
            stack.func_227861_a_(0.5, 0.5, 0.5);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotateAngleZ * 57.295776f));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotateAngleY * 57.295776f + (float)c * (360.0f / (float)count)));
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotateAngleX * 57.295776f));
            stack.func_227861_a_(-0.5, -0.5, -0.5);
            stack.func_227861_a_(0.0, 0.0, (double)-0.7f);
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(LOC);
            for (Direction dir : DIRS) {
                RAND.setSeed(42L);
                Minecraft.func_71410_x().func_175599_af().func_229112_a_(stack, buffer.getBuffer(Atlases.func_228785_j_()), model.getQuads(null, dir, RAND, (IModelData)EmptyModelData.INSTANCE), ItemStack.field_190927_a, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            stack.func_227865_b_();
        }
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int light, T living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.getShieldCount(living) > 0) {
            this.renderShields(stack, buffer, living, partialTicks);
        }
    }
}

