/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;
import twilightforest.TwilightForestMod;
import twilightforest.data.WorldDataCompilerAndOps;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.TFBiomeProvider;
import twilightforest.world.TFDimensions;
import twilightforest.worldgen.ConfiguredSurfaceBuilders;
import twilightforest.worldgen.biomes.BiomeMaker;

public class TwilightWorldDataCompiler
extends WorldDataCompilerAndOps<JsonElement> {
    public TwilightWorldDataCompiler(DataGenerator generator) {
        super(generator, JsonOps.INSTANCE, arg_0 -> ((Gson)GSON).toJson(arg_0), (DynamicRegistries)new DynamicRegistries.Impl());
    }

    @Override
    public void generate(DirectoryCache directoryCache) {
        ConfiguredSurfaceBuilders.registerConfigurations(this.field_240895_b_.func_243612_b(Registry.field_243550_as));
        this.getBiomes().forEach((rl, biome) -> this.serialize(Registry.field_239720_u_, (ResourceLocation)rl, biome, Biome.field_242418_b));
        this.getDimensions().forEach((rl, dimension) -> this.serialize(Registry.field_239700_af_, (ResourceLocation)rl, dimension, Dimension.field_236052_a_));
    }

    private Map<ResourceLocation, Dimension> getDimensions() {
        Optional<DimensionSettings> forestDimensionSettings = TwilightWorldDataCompiler.makeDimensionSettings(new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of()), new NoiseSettings(128, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, false, true, false, false), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), -20, 0, 31, false);
        Optional<DimensionSettings> skyDimensionSettings = TwilightWorldDataCompiler.makeDimensionSettings(new DimensionStructuresSettings(Optional.empty(), (Map)ImmutableMap.of()), new NoiseSettings(128, new ScalingSettings(3.0, 1.0, 256.0, 16.0), new SlideSettings(-3000, 92, -66), new SlideSettings(-30, 7, 1), 2, 1, 0.3, -0.2, true, false, false, false), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), -20, -20, 0, false);
        this.getOrCreateInRegistry(this.field_240895_b_.func_243612_b(Registry.field_243549_ar), RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)TwilightForestMod.prefix("forest_noise_config")), forestDimensionSettings::get);
        this.getOrCreateInRegistry(this.field_240895_b_.func_243612_b(Registry.field_243549_ar), RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)TwilightForestMod.prefix("sky_noise_config")), skyDimensionSettings::get);
        TFDimensions.init();
        ChunkGeneratorTwilightForest forestChunkGen = new ChunkGeneratorTwilightForest(new TFBiomeProvider(0L, (Registry<Biome>)new SimpleRegistry(Registry.field_239720_u_, Lifecycle.experimental())), 0L, forestDimensionSettings::get);
        NoiseChunkGenerator skyChunkGen = new NoiseChunkGenerator((BiomeProvider)new TFBiomeProvider(0L, (Registry<Biome>)new SimpleRegistry(Registry.field_239720_u_, Lifecycle.experimental())), 0L, skyDimensionSettings::get);
        Optional<DimensionType> twilightType = TwilightWorldDataCompiler.makeDimensionType(OptionalLong.of(13000L), true, false, false, true, 0.125, false, false, true, true, false, 256, (IBiomeMagnifier)FuzzedBiomeMagnifier.INSTANCE, new ResourceLocation("infiniburn_overworld"), TwilightForestMod.prefix("renderer"), 0.0f);
        this.getOrCreateInRegistry(this.field_240895_b_.func_243612_b(Registry.field_239698_ad_), RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation("twilightforest", "forest_type")), twilightType::get);
        return ImmutableMap.of((Object)TwilightForestMod.prefix("twilightforest"), (Object)new Dimension(twilightType::get, (ChunkGenerator)forestChunkGen), (Object)TwilightForestMod.prefix("skylight_forest"), (Object)new Dimension(twilightType::get, (ChunkGenerator)skyChunkGen));
    }

    private Map<ResourceLocation, Biome> getBiomes() {
        return BiomeMaker.BIOMES.entrySet().stream().peek(registryKeyBiomeEntry -> {
            Biome cfr_ignored_0 = (Biome)((Biome)registryKeyBiomeEntry.getValue()).setRegistryName(((RegistryKey)registryKeyBiomeEntry.getKey()).func_240901_a_());
        }).collect(Collectors.toMap(entry -> ((RegistryKey)entry.getKey()).func_240901_a_(), Map.Entry::getValue));
    }
}

