/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.HostileWolfEntity;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.BreathAttackGoal;
import twilightforest.worldgen.biomes.BiomeKeys;

public class WinterWolfEntity
extends HostileWolfEntity
implements IBreathAttacker {
    private static final DataParameter<Boolean> BREATH_FLAG = EntityDataManager.func_187226_a(WinterWolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final float BREATH_DAMAGE = 2.0f;

    public WinterWolfEntity(EntityType<? extends WinterWolfEntity> type, World world) {
        super(type, world);
        this.func_175547_a(DyeColor.LIGHT_BLUE);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, new BreathAttackGoal<WinterWolfEntity>(this, 5.0f, 30, 0.1f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return HostileWolfEntity.registerAttributes().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BREATH_FLAG, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBreathing()) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnBreathParticles();
            }
            this.playBreathSound();
        }
    }

    private void spawnBreathParticles() {
        Vector3d look = this.func_70040_Z();
        double dist = 0.5;
        double px = this.func_226277_ct_() + look.field_72450_a * 0.5;
        double py = this.func_226278_cu_() + 1.25 + look.field_72448_b * 0.5;
        double pz = this.func_226281_cx_() + look.field_72449_c * 0.5;
        for (int i = 0; i < 10; ++i) {
            double dx = look.field_72450_a;
            double dy = look.field_72448_b;
            double dz = look.field_72449_c;
            double spread = 5.0 + this.func_70681_au().nextDouble() * 2.5;
            double velocity = 3.0 + this.func_70681_au().nextDouble() * 0.15;
            dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            dy += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
            this.field_70170_p.func_195594_a((IParticleData)TFParticleType.SNOW.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }

    @Override
    public void func_70624_b(@Nullable LivingEntity entity) {
        if (entity != null && entity != this.func_70638_az()) {
            this.func_184185_a(TFSounds.WINTER_WOLF_TARGET, 4.0f, this.func_70647_i());
        }
        super.func_70624_b(entity);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return TFSounds.WINTER_WOLF_IDLE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFSounds.WINTER_WOLF_HURT;
    }

    private void playBreathSound() {
        this.func_184185_a(TFSounds.WINTER_WOLF_SHOOT, this.field_70146_Z.nextFloat() * 0.5f, this.field_70146_Z.nextFloat() * 0.5f);
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TFSounds.WINTER_WOLF_DEATH;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.field_70180_af.func_187225_a(BREATH_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.field_70180_af.func_187227_b(BREATH_FLAG, (Object)flag);
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
    }

    public static boolean canSpawnHere(EntityType<? extends WinterWolfEntity> entity, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        Optional key = world.func_242406_i(pos);
        return Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST)) || MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random);
    }
}

