/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import twilightforest.entity.IBreathAttacker;

public class BreathAttackGoal<T extends MobEntity>
extends Goal {
    private final T entityHost;
    private LivingEntity attackTarget;
    private double breathX;
    private double breathY;
    private double breathZ;
    private final int maxDuration;
    private final float attackChance;
    private final float breathRange;
    private int durationLeft;

    public BreathAttackGoal(T living, float range, int time, float chance) {
        this.entityHost = living;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        this.attackTarget = this.entityHost.func_70643_av();
        if (this.attackTarget == null || this.entityHost.func_70032_d((Entity)this.attackTarget) > this.breathRange || !this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget) || !EntityPredicates.field_233583_f_.test(this.attackTarget)) {
            return false;
        }
        this.breathX = this.attackTarget.func_226277_ct_();
        this.breathY = this.attackTarget.func_226278_cu_() + (double)this.attackTarget.func_70047_e();
        this.breathZ = this.attackTarget.func_226281_cx_();
        return this.entityHost.func_70681_au().nextFloat() < this.attackChance;
    }

    public void func_75249_e() {
        this.durationLeft = this.maxDuration;
        ((IBreathAttacker)this.entityHost).setBreathing(true);
    }

    public boolean func_75253_b() {
        return this.durationLeft > 0 && this.entityHost.func_70089_S() && this.attackTarget.func_70089_S() && this.entityHost.func_70032_d((Entity)this.attackTarget) <= this.breathRange && this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget) && EntityPredicates.field_233583_f_.test(this.attackTarget);
    }

    public void func_75246_d() {
        Entity target;
        --this.durationLeft;
        this.entityHost.func_70671_ap().func_75650_a(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        this.faceVec(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
        }
    }

    public void func_75251_c() {
        this.durationLeft = 0;
        this.attackTarget = null;
        ((IBreathAttacker)this.entityHost).setBreathing(false);
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        double offset = 3.0;
        Vector3d srcVec = new Vector3d(this.entityHost.func_226277_ct_(), this.entityHost.func_226278_cu_() + 0.25, this.entityHost.func_226281_cx_());
        Vector3d lookVec = this.entityHost.func_70676_i(1.0f);
        Vector3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 0.5f;
        List possibleList = ((MobEntity)this.entityHost).field_70170_p.func_72839_b(this.entityHost, this.entityHost.func_174813_aQ().func_72317_d(lookVec.field_72450_a * offset, lookVec.field_72448_b * offset, lookVec.field_72449_c * offset).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        if (this.entityHost.isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList((Object[])Objects.requireNonNull(this.entityHost.getParts())));
        }
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L() || possibleEntity == this.entityHost || !EntityPredicates.field_233583_f_.test(possibleEntity)) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.func_216365_b(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.func_72438_d((Vector3d)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(double x, double y, double z, float yawConstraint, float pitchConstraint) {
        double xOffset = x - this.entityHost.func_226277_ct_();
        double zOffset = z - this.entityHost.func_226281_cx_();
        double yOffset = this.entityHost.func_226278_cu_() + 0.25 - y;
        double distance = MathHelper.func_76133_a((double)(xOffset * xOffset + zOffset * zOffset));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        ((MobEntity)this.entityHost).field_70125_A = -this.updateRotation(((MobEntity)this.entityHost).field_70125_A, zdAngle, pitchConstraint);
        ((MobEntity)this.entityHost).field_70177_z = this.updateRotation(((MobEntity)this.entityHost).field_70177_z, xyAngle, yawConstraint);
    }

    private float updateRotation(float current, float target, float maxDelta) {
        float delta = MathHelper.func_76142_g((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }
}

