/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import twilightforest.entity.ai.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueenEntity;

public class HoverBeamGoal
extends HoverBaseGoal<SnowQueenEntity> {
    private int hoverTimer;
    private int beamTimer;
    private int seekTimer;
    private final int maxHoverTime;
    private final int maxBeamTime;
    private final int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public HoverBeamGoal(SnowQueenEntity snowQueen, int hoverTime, int dropTime) {
        super(snowQueen, 3.0f, 4.0f);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean func_75250_a() {
        LivingEntity target = ((SnowQueenEntity)this.attacker).func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        return ((SnowQueenEntity)this.attacker).getCurrentPhase() == SnowQueenEntity.Phase.BEAM;
    }

    public boolean func_75253_b() {
        LivingEntity target = ((SnowQueenEntity)this.attacker).func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (((SnowQueenEntity)this.attacker).getCurrentPhase() != SnowQueenEntity.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void func_75251_c() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        ((SnowQueenEntity)this.attacker).setBreathing(false);
    }

    public void func_75246_d() {
        LivingEntity target;
        if (((SnowQueenEntity)this.attacker).func_70092_e(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            ((SnowQueenEntity)this.attacker).setBreathing(true);
            this.doRayAttack();
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - ((SnowQueenEntity)this.attacker).func_226277_ct_();
        double offsetY = this.hoverPosY - ((SnowQueenEntity)this.attacker).func_226278_cu_();
        double offsetZ = this.hoverPosZ - ((SnowQueenEntity)this.attacker).func_226281_cx_();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)MathHelper.func_76133_a((double)distanceDesired)) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            ((SnowQueenEntity)this.attacker).func_70024_g(velX, velY += (double)0.02f, velZ);
        }
        if ((target = ((SnowQueenEntity)this.attacker).func_70638_az()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            ((SnowQueenEntity)this.attacker).func_70625_a((Entity)target, tracking, tracking);
            ((SnowQueenEntity)this.attacker).func_70671_ap().func_75651_a((Entity)target, tracking, tracking);
        }
    }

    private void doRayAttack() {
        double range = 20.0;
        double offset = 10.0;
        Vector3d srcVec = new Vector3d(((SnowQueenEntity)this.attacker).func_226277_ct_(), ((SnowQueenEntity)this.attacker).func_226278_cu_() + 0.25, ((SnowQueenEntity)this.attacker).func_226281_cx_());
        Vector3d lookVec = ((SnowQueenEntity)this.attacker).func_70676_i(1.0f);
        Vector3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        List possibleList = ((SnowQueenEntity)this.attacker).field_70170_p.func_72839_b((Entity)this.attacker, ((SnowQueenEntity)this.attacker).func_174813_aQ().func_72317_d(lookVec.field_72450_a * offset, lookVec.field_72448_b * offset, lookVec.field_72449_c * offset).func_72314_b(range, range, range));
        double hitDist = 0.0;
        if (((SnowQueenEntity)this.attacker).isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList((Object[])Objects.requireNonNull(((SnowQueenEntity)this.attacker).getParts())));
        }
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.func_216365_b(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                ((SnowQueenEntity)this.attacker).doBreathAttack(possibleEntity);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.func_72438_d((Vector3d)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            ((SnowQueenEntity)this.attacker).doBreathAttack(possibleEntity);
            hitDist = possibleDist;
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.beamY = target.func_226278_cu_();
        this.seekTimer = 0;
    }
}

