/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;
import twilightforest.entity.ai.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueenEntity;

public class HoverSummonGoal
extends HoverBaseGoal<SnowQueenEntity> {
    private static final int MAX_MINIONS_AT_ONCE = 4;
    private int seekTimer;
    private final int maxSeekTime;

    public HoverSummonGoal(SnowQueenEntity snowQueen) {
        super(snowQueen, 6.0f, 6.0f);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxSeekTime = 80;
    }

    public boolean func_75250_a() {
        LivingEntity target = ((SnowQueenEntity)this.attacker).func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (((SnowQueenEntity)this.attacker).getCurrentPhase() != SnowQueenEntity.Phase.SUMMON) {
            return false;
        }
        return ((SnowQueenEntity)this.attacker).func_70635_at().func_75522_a((Entity)target);
    }

    public boolean func_75253_b() {
        LivingEntity target = ((SnowQueenEntity)this.attacker).func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (((SnowQueenEntity)this.attacker).getCurrentPhase() != SnowQueenEntity.Phase.SUMMON) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        return this.canEntitySee((Entity)this.attacker, this.hoverPosX, this.hoverPosY, this.hoverPosZ);
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        ++this.seekTimer;
        LivingEntity target = ((SnowQueenEntity)this.attacker).func_70638_az();
        if (((SnowQueenEntity)this.attacker).func_70092_e(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.checkAndSummon();
            this.makeNewHoverSpot(target);
        }
        double offsetX = this.hoverPosX - ((SnowQueenEntity)this.attacker).func_226277_ct_();
        double offsetY = this.hoverPosY - ((SnowQueenEntity)this.attacker).func_226278_cu_();
        double offsetZ = this.hoverPosZ - ((SnowQueenEntity)this.attacker).func_226281_cx_();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        distanceDesired = MathHelper.func_76133_a((double)distanceDesired);
        double velX = offsetX / distanceDesired * 0.05;
        double velY = offsetY / distanceDesired * 0.1;
        double velZ = offsetZ / distanceDesired * 0.05;
        ((SnowQueenEntity)this.attacker).func_70024_g(velX, velY += (double)0.05f, velZ);
        if (target != null) {
            ((SnowQueenEntity)this.attacker).func_70625_a((Entity)target, 30.0f, 30.0f);
            ((SnowQueenEntity)this.attacker).func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.seekTimer = 0;
    }

    private void checkAndSummon() {
        if (((SnowQueenEntity)this.attacker).getSummonsRemaining() > 0 && ((SnowQueenEntity)this.attacker).countMyMinions() < 4) {
            ((SnowQueenEntity)this.attacker).summonMinionAt(((SnowQueenEntity)this.attacker).func_70638_az());
        }
    }
}

