/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;

public class BighornEntity
extends SheepEntity {
    public BighornEntity(EntityType<? extends BighornEntity> type, World world) {
        super(type, world);
    }

    public BighornEntity(World world, double x, double y, double z) {
        this(TFEntities.bighorn_sheep, world);
        this.func_70107_b(x, y, z);
    }

    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.func_175509_cj()) {
            default: {
                return TFTreasure.BIGHORN_SHEEP_WHITE;
            }
            case ORANGE: {
                return TFTreasure.BIGHORN_SHEEP_ORANGE;
            }
            case MAGENTA: {
                return TFTreasure.BIGHORN_SHEEP_MAGENTA;
            }
            case LIGHT_BLUE: {
                return TFTreasure.BIGHORN_SHEEP_LIGHT_BLUE;
            }
            case YELLOW: {
                return TFTreasure.BIGHORN_SHEEP_YELLOW;
            }
            case LIME: {
                return TFTreasure.BIGHORN_SHEEP_LIME;
            }
            case PINK: {
                return TFTreasure.BIGHORN_SHEEP_PINK;
            }
            case GRAY: {
                return TFTreasure.BIGHORN_SHEEP_GRAY;
            }
            case LIGHT_GRAY: {
                return TFTreasure.BIGHORN_SHEEP_LIGHT_GRAY;
            }
            case CYAN: {
                return TFTreasure.BIGHORN_SHEEP_CYAN;
            }
            case PURPLE: {
                return TFTreasure.BIGHORN_SHEEP_PURPLE;
            }
            case BLUE: {
                return TFTreasure.BIGHORN_SHEEP_BLUE;
            }
            case BROWN: {
                return TFTreasure.BIGHORN_SHEEP_BROWN;
            }
            case GREEN: {
                return TFTreasure.BIGHORN_SHEEP_GREEN;
            }
            case RED: {
                return TFTreasure.BIGHORN_SHEEP_RED;
            }
            case BLACK: 
        }
        return TFTreasure.BIGHORN_SHEEP_BLACK;
    }

    private static DyeColor getRandomFleeceColor(Random random) {
        return random.nextBoolean() ? DyeColor.BROWN : DyeColor.func_196056_a((int)random.nextInt(16));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT dataTag) {
        livingdata = super.func_213386_a(worldIn, difficulty, reason, livingdata, dataTag);
        this.func_175512_b(BighornEntity.getRandomFleeceColor(this.field_70170_p.field_73012_v));
        return livingdata;
    }

    public SheepEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        if (!(ageable instanceof BighornEntity)) {
            TwilightForestMod.LOGGER.error("Code was called to breed a Bighorn with a non Bighorn! Cancelling!");
            return null;
        }
        BighornEntity otherParent = (BighornEntity)ageable;
        BighornEntity babySheep = (BighornEntity)TFEntities.bighorn_sheep.func_200721_a((World)world);
        babySheep.func_175512_b(this.func_175511_a((AnimalEntity)this, (AnimalEntity)otherParent));
        return babySheep;
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.BIGHORN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSounds.BIGHORN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.BIGHORN_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(TFSounds.BIGHORN_STEP, 0.15f, 1.0f);
    }
}

