/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.client.model.armor.ArcticArmorModel;

public class ArcticArmorItem
extends ArmorItem
implements IDyeableArmorItem {
    private static final Map<EquipmentSlotType, BipedModel<?>> arcticArmorModel = new EnumMap(EquipmentSlotType.class);

    public ArcticArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType armorType, Item.Properties props) {
        super(armorMaterial, armorType, props);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlotType slot, String layer) {
        if (slot == EquipmentSlotType.LEGS) {
            return "twilightforest:textures/armor/arcticarmor_2" + (layer == null ? "_dyed" : "_overlay") + ".png";
        }
        return "twilightforest:textures/armor/arcticarmor_1" + (layer == null ? "_dyed" : "_overlay") + ".png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A oldM) {
        return (A)arcticArmorModel.get(armorSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initArmorModel() {
        arcticArmorModel.put(EquipmentSlotType.HEAD, new ArcticArmorModel(0.75f));
        arcticArmorModel.put(EquipmentSlotType.CHEST, new ArcticArmorModel(1.0f));
        arcticArmorModel.put(EquipmentSlotType.LEGS, new ArcticArmorModel(0.5f));
        arcticArmorModel.put(EquipmentSlotType.FEET, new ArcticArmorModel(1.0f));
    }

    public boolean func_200883_f_(ItemStack stack) {
        CompoundNBT CompoundNBT2 = stack.func_77978_p();
        return CompoundNBT2 != null && CompoundNBT2.func_150297_b("display", 10) && CompoundNBT2.func_74775_l("display").func_150297_b("color", 3);
    }

    public int func_200886_f(ItemStack stack) {
        return this.getColor(stack, 1);
    }

    public void func_200884_g(ItemStack stack) {
        this.removeColor(stack, 1);
    }

    public void func_200885_a(ItemStack stack, int color) {
        this.setColor(stack, color, 1);
    }

    public int getColor(ItemStack stack, int type) {
        CompoundNBT displayCompound;
        String string = "";
        CompoundNBT stackTagCompound = stack.func_77978_p();
        int color = 12439513;
        if (stackTagCompound != null && (displayCompound = stackTagCompound.func_74775_l("display")).func_150297_b("color" + string, 3)) {
            color = displayCompound.func_74762_e("color" + string);
        }
        switch (type) {
            case 0: {
                return 0xFFFFFF;
            }
        }
        return color;
    }

    public void removeColor(ItemStack stack, int type) {
        String string = "";
        CompoundNBT stackTagCompound = stack.func_77978_p();
        if (stackTagCompound != null) {
            CompoundNBT displayCompound = stackTagCompound.func_74775_l("display");
            if (displayCompound.func_74764_b("color" + string)) {
                displayCompound.func_82580_o("color" + string);
            }
            if (displayCompound.func_74764_b("hasColor")) {
                displayCompound.func_74757_a("hasColor", false);
            }
        }
    }

    public void setColor(ItemStack stack, int color, int type) {
        String string = "";
        CompoundNBT stackTagCompound = stack.func_77978_p();
        if (stackTagCompound == null) {
            stackTagCompound = new CompoundNBT();
            stack.func_77982_d(stackTagCompound);
        }
        CompoundNBT displayCompound = stackTagCompound.func_74775_l("display");
        if (!stackTagCompound.func_150297_b("display", 10)) {
            stackTagCompound.func_218657_a("display", (INBT)displayCompound);
        }
        displayCompound.func_74768_a("color" + string, color);
        displayCompound.func_74757_a("hasColor", true);
    }

    public ActionResultType onItemUseFirst(ItemStack itemstack, ItemUseContext context) {
        BlockState blockAt;
        if (this.func_200883_f_(itemstack) && (blockAt = context.func_195991_k().func_180495_p(context.func_195995_a())).func_177230_c() instanceof CauldronBlock && (Integer)blockAt.func_177229_b((Property)CauldronBlock.field_176591_a) > 0) {
            this.func_200884_g(itemstack);
            context.func_195999_j().func_195066_a(Stats.field_188079_M);
            ((CauldronBlock)blockAt.func_177230_c()).func_176590_a(context.func_195991_k(), context.func_195995_a(), blockAt, (Integer)blockAt.func_177229_b((Property)CauldronBlock.field_176591_a) - 1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.twilightforest.arctic_armor.tooltip"));
    }
}

