/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFEntities;
import twilightforest.entity.projectile.MoonwormShotEntity;

public class MoonwormQueenItem
extends Item {
    protected static final int FIRING_TIME = 12;

    protected MoonwormQueenItem(Item.Properties props) {
        super(props);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack itemstack;
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState iblockstate = worldIn.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        BlockItemUseContext blockItemUseContext = new BlockItemUseContext(context);
        if (!iblockstate.func_185904_a().func_76222_j()) {
            pos = pos.func_177972_a(context.func_196000_l());
        }
        if ((itemstack = player.func_184586_b(context.func_221531_n())).func_77952_i() < itemstack.func_77958_k() && player.func_175151_a(pos, context.func_196000_l(), itemstack) && worldIn.func_226663_a_(((Block)TFBlocks.moonworm.get()).func_176223_P(), pos, ISelectionContext.func_216377_a())) {
            if (this.tryPlace(blockItemUseContext).func_226247_b_()) {
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), (IWorldReader)worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                player.func_184602_cy();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int useRemaining) {
        boolean fired;
        int useTime = this.func_77626_a(stack) - useRemaining;
        if (!world.field_72995_K && useTime > 12 && stack.func_77952_i() + 1 < stack.func_77958_k() && (fired = world.func_217376_c((Entity)new MoonwormShotEntity((EntityType<? extends MoonwormShotEntity>)TFEntities.moonworm_shot, world, living)))) {
            stack.func_222118_a(2, living, user -> user.func_213334_d(living.func_184600_cs()));
            world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), TFSounds.MOONWORM_SQUISH, living instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResultType tryPlace(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.getBlockItemUseContext(context);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerentity = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            blockstate1 = this.func_219985_a(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack);
            block.func_180633_a(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)context.func_195999_j());
        world.func_184133_a(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, context.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            itemstack.func_222118_a(1, (LivingEntity)playerentity, user -> user.func_213334_d(playerentity.func_184600_cs()));
        }
        return ActionResultType.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    @Nullable
    public BlockItemUseContext getBlockItemUseContext(BlockItemUseContext context) {
        return context;
    }

    protected boolean onBlockPlaced(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack) {
        return BlockItem.func_179224_a((World)worldIn, (PlayerEntity)player, (BlockPos)pos, (ItemStack)stack);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockItemUseContext context) {
        BlockState blockstate = ((Block)TFBlocks.moonworm.get()).func_196258_a(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        PlayerEntity playerentity = p_195944_1_.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return p_195944_2_.func_196955_c((IWorldReader)p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a()) && p_195944_1_.func_195991_k().func_226663_a_(p_195944_2_, p_195944_1_.func_195995_a(), iselectioncontext);
    }

    private BlockState func_219985_a(BlockPos p_219985_1_, World p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundNBT compoundnbt = p_219985_3_.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = p_219985_4_.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = MoonwormQueenItem.func_219988_a(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.func_180501_a(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState func_219988_a(BlockState p_219988_0_, Property<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.func_185929_b(p_219988_2_).map(p_219986_2_ -> (BlockState)p_219988_0_.func_206870_a(p_219988_1_, p_219986_2_)).orElse(p_219988_0_);
    }

    protected boolean placeBlock(BlockItemUseContext context, BlockState state) {
        return context.func_195991_k().func_180501_a(context.func_195995_a(), state, 11);
    }
}

