/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.BindingCurseEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.VanishingCurseEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.client.model.armor.PhantomArmorModel;

public class PhantomArmorItem
extends ArmorItem {
    private static final Map<EquipmentSlotType, BipedModel<?>> phantomArmorModel = new EnumMap(EquipmentSlotType.class);

    public PhantomArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType armorType, Item.Properties props) {
        super(armorMaterial, armorType, props);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlotType slot, String layer) {
        return "twilightforest:textures/armor/phantom_1.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A original) {
        return (A)phantomArmorModel.get(armorSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initArmorModel() {
        phantomArmorModel.put(EquipmentSlotType.HEAD, new PhantomArmorModel(EquipmentSlotType.HEAD, 0.75f));
        phantomArmorModel.put(EquipmentSlotType.CHEST, new PhantomArmorModel(EquipmentSlotType.CHEST, 1.0f));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !(enchantment instanceof VanishingCurseEnchantment) && !(enchantment instanceof BindingCurseEnchantment) && enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip"));
    }
}

