/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.ProtectionBoxEntity;

public class AreaProtectionPacket {
    private final MutableBoundingBox sbb;
    private final BlockPos pos;

    public AreaProtectionPacket(MutableBoundingBox sbb, BlockPos pos) {
        this.sbb = sbb;
        this.pos = pos;
    }

    public AreaProtectionPacket(PacketBuffer buf) {
        this.sbb = new MutableBoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        this.pos = buf.func_179259_c();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.sbb.field_78897_a);
        buf.writeInt(this.sbb.field_78895_b);
        buf.writeInt(this.sbb.field_78896_c);
        buf.writeInt(this.sbb.field_78893_d);
        buf.writeInt(this.sbb.field_78894_e);
        buf.writeInt(this.sbb.field_78892_f);
        buf.writeLong(this.pos.func_218275_a());
    }

    public static class Handler {
        public static boolean onMessage(final AreaProtectionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                    Handler.addProtectionBox(world, message.sbb);
                    for (int i = 0; i < 20; ++i) {
                        double vx = world.field_73012_v.nextGaussian() * 0.02;
                        double vy = world.field_73012_v.nextGaussian() * 0.02;
                        double vz = world.field_73012_v.nextGaussian() * 0.02;
                        double x = (double)message.pos.func_177958_n() + 0.5 + (double)world.field_73012_v.nextFloat() - (double)world.field_73012_v.nextFloat();
                        double y = (double)message.pos.func_177956_o() + 0.5 + (double)world.field_73012_v.nextFloat() - (double)world.field_73012_v.nextFloat();
                        double z = (double)message.pos.func_177952_p() + 0.5 + (double)world.field_73012_v.nextFloat() - (double)world.field_73012_v.nextFloat();
                        world.func_195594_a((IParticleData)TFParticleType.PROTECTION.get(), x, y, z, vx, vy, vz);
                    }
                }
            });
            return true;
        }

        static void addProtectionBox(ClientWorld world, MutableBoundingBox sbb) {
            for (Entity entity : world.func_217416_b()) {
                if (!(entity instanceof ProtectionBoxEntity)) continue;
                ProtectionBoxEntity protectionBox = (ProtectionBoxEntity)entity;
                if (protectionBox.lifeTime <= 0 || !protectionBox.matches(sbb)) continue;
                protectionBox.resetLifetime();
                return;
            }
            world.func_217376_c((Entity)new ProtectionBoxEntity((World)world, sbb));
        }
    }
}

