/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.darktower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.darktower.DarkTowerPieces;
import twilightforest.structures.darktower.DarkTowerWingComponent;
import twilightforest.structures.lichtower.TowerWingComponent;

public class DarkTowerBridgeComponent
extends TowerWingComponent {
    private int dSize;
    private int dHeight;

    public DarkTowerBridgeComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public DarkTowerBridgeComponent(TemplateManager manager, CompoundNBT nbt) {
        super(DarkTowerPieces.TFDTBri, nbt);
    }

    protected DarkTowerBridgeComponent(IStructurePieceType type, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(type, feature, i, x, y, z, 5, 5, direction);
        this.dSize = pSize;
        this.dHeight = pHeight;
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.makeTowerWing(list, rand, this.func_74877_c(), 4, 1, 2, this.dSize, this.dHeight, Rotation.NONE);
    }

    @Override
    public boolean makeTowerWing(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        if (wingHeight < 6) {
            return false;
        }
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (dx[1] + wingHeight > 255) {
            return false;
        }
        DarkTowerWingComponent wing = new DarkTowerWingComponent(DarkTowerPieces.TFDTWin, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)wing.func_74874_b());
        if (intersect == null || intersect == this) {
            list.add(wing);
            ((TowerWingComponent)wing).func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.func_175804_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, this.deco.blockState, this.deco.blockState, false);
        for (int x = 0; x < this.size; ++x) {
            this.func_175811_a(world, this.deco.accentState, x, 0, 0, sbb);
            this.func_175811_a(world, this.deco.accentState, x, this.height - 1, 0, sbb);
            this.func_175811_a(world, this.deco.accentState, x, 0, this.size - 1, sbb);
            this.func_175811_a(world, this.deco.accentState, x, this.height - 1, this.size - 1, sbb);
        }
        this.func_74878_a(world, sbb, 0, 1, 1, this.size - 1, this.height - 2, this.size - 2);
        return true;
    }

    public MutableBoundingBox getWingBB() {
        int[] dest = this.offsetTowerCoords(4, 1, 2, this.dSize, this.func_186165_e());
        return this.feature.getComponentToAddBoundingBox(dest[0], dest[1], dest[2], 0, 0, 0, this.dSize - 1, this.dHeight - 1, this.dSize - 1, this.func_186165_e());
    }
}

