/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.util.RotationUtil;

public class FinalCastleFoundation13Component
extends TFStructureComponentOld {
    protected int groundLevel = -1;
    protected static final Predicate<BlockState> isDeadrock = state -> state.func_177230_c() == TFBlocks.deadrock.get();

    public FinalCastleFoundation13Component(TemplateManager manager, CompoundNBT nbt) {
        this(FinalCastlePieces.TFFCToF13, nbt);
    }

    public FinalCastleFoundation13Component(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public FinalCastleFoundation13Component(IStructurePieceType type, TFFeature feature, Random rand, int i, TFStructureComponentOld sideTower) {
        super(type, feature, i);
        this.func_186164_a(sideTower.func_186165_e());
        this.field_74887_e = new MutableBoundingBox(sideTower.func_74874_b().field_78897_a - 2, sideTower.func_74874_b().field_78895_b - 1, sideTower.func_74874_b().field_78896_c - 2, sideTower.func_74874_b().field_78893_d + 2, sideTower.func_74874_b().field_78895_b, sideTower.func_74874_b().field_78892_f + 2);
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random randomIn, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        if (this.groundLevel < 0) {
            this.groundLevel = this.findGroundLevel(world, sbb, 150, isDeadrock);
            if (this.groundLevel < 0) {
                return true;
            }
        }
        int height = this.field_74887_e.field_78894_e - this.groundLevel;
        int mid = height / 2;
        int size = this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a;
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, 1, -1, 1, rotation, sbb);
            this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, 2, -1, 1, rotation, sbb);
            this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, 2, -mid, 0, rotation, sbb);
            this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, 1, -1, 2, rotation, sbb);
            this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, 0, -mid, 2, rotation, sbb);
            for (int x = 6; x < size - 3; x += 4) {
                this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, x, -1, 1, rotation, sbb);
                this.replaceAirAndLiquidDownwardsRotated(world, this.deco.blockState, x, -mid, 0, rotation, sbb);
            }
        }
        return true;
    }
}

