/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.lichtower.TowerRoofComponent;
import twilightforest.structures.lichtower.TowerWingComponent;

public class TowerRoofPointyComponent
extends TowerRoofComponent {
    public TowerRoofPointyComponent(TemplateManager manager, CompoundNBT nbt) {
        super(LichTowerPieces.TFLTRP, nbt);
    }

    public TowerRoofPointyComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public TowerRoofPointyComponent(IStructurePieceType piece, TFFeature feature, int i, TowerWingComponent wing) {
        super(piece, feature, i);
        this.func_186164_a(wing.func_186165_e());
        this.height = this.size = wing.size;
        this.makeCapBB(wing);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState birchSlab = Blocks.field_196627_bs.func_176223_P();
        BlockState birchPlanks = Blocks.field_196666_p.func_176223_P();
        for (int y = 0; y <= this.height; ++y) {
            int max;
            int min;
            int slopeChange = this.slopeChangeForSize();
            if (y < slopeChange) {
                min = y;
                max = this.size - y - 1;
            } else {
                min = (y + slopeChange) / 2;
                max = this.size - (y + slopeChange) / 2 - 1;
            }
            int mid = min + (max - min) / 2;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    this.func_175811_a(world, birchPlanks, x, y, z, sbb);
                    if (x == min && (z == min || z == max) || x == max && (z == min || z == max)) {
                        this.func_175811_a(world, birchSlab, x, y + 1, z, sbb);
                    }
                    if ((x != min && x != max || z != mid || x % 2 != 0) && (z != min && z != max || x != mid || z % 2 != 0) || mid == min + 1) continue;
                    this.func_175811_a(world, birchSlab, x, y + 1, z, sbb);
                }
            }
        }
        return true;
    }

    public int slopeChangeForSize() {
        if (this.size > 10) {
            return 3;
        }
        if (this.size > 6) {
            return 2;
        }
        return 1;
    }
}

