/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import org.apache.commons.lang3.mutable.MutableBoolean;
import twilightforest.block.TFBlocks;

public class TFCavesCarver
extends WorldCarver<ProbabilityConfig> {
    private final boolean isHighlands;

    public TFCavesCarver(Codec<ProbabilityConfig> codec, int maxheight, boolean isHighlands) {
        super(codec, maxheight);
        this.field_222719_k = ImmutableSet.of();
        this.isHighlands = isHighlands;
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return rand.nextFloat() <= config.field_203622_a;
    }

    public boolean carveRegion(IChunk chunk, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, ProbabilityConfig config) {
        int size = (this.func_222704_c() * 2 - 1) * 16;
        int maxcaves = rand.nextInt(rand.nextInt(rand.nextInt(45) + 1) + 1);
        for (int k = 0; k < maxcaves; ++k) {
            double randx = chunkXOffset * 16 + rand.nextInt(16);
            double randy = this.func_230361_b_(rand);
            double randz = chunkZOffset * 16 + rand.nextInt(16);
            int l = 1;
            if (rand.nextInt(4) == 0) {
                float cavesize = 1.0f + rand.nextFloat() * 6.0f;
                this.genLargeNode(chunk, biomePos, rand.nextLong(), seaLevel, chunkX, chunkZ, randx, randy, randz, cavesize, 0.5, carvingMask);
                l += rand.nextInt(4);
            }
            for (int k1 = 0; k1 < l; ++k1) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                float f3 = (rand.nextFloat() - 0.5f) / 4.0f;
                float f2 = this.func_230359_a_(rand);
                int i1 = size - rand.nextInt(size / 4);
                this.genNode(chunk, biomePos, rand.nextLong(), seaLevel, chunkX, chunkZ, randx, randy, randz, f2, f, f3, 0, i1, this.func_230360_b_(), carvingMask, this.isHighlands);
            }
        }
        return true;
    }

    protected float func_230359_a_(Random rand) {
        float f = rand.nextFloat() * 2.0f + rand.nextFloat();
        if (rand.nextInt(10) == 0) {
            f *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double func_230360_b_() {
        return 1.0;
    }

    protected int func_230361_b_(Random rand) {
        return rand.nextInt(rand.nextInt(120) + 8);
    }

    protected void genLargeNode(IChunk chunk, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double randOffsetXCoord, double startY, double randOffsetZCoord, float p_227205_14_, double p_227205_15_, BitSet carvingMask) {
        double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)1.5707964f) * p_227205_14_);
        double d1 = d0 * p_227205_15_;
        this.func_227208_a_(chunk, biomePos, seed, seaLevel, chunkX, chunkZ, randOffsetXCoord + 1.0, startY, randOffsetZCoord, d0, d1, carvingMask);
    }

    protected void genNode(IChunk chunk, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double randOffsetXCoord, double startY, double randOffsetZCoord, float caveRadius, float pitch, float p_227206_16_, int p_227206_17_, int p_227206_18_, double p_227206_19_, BitSet p_227206_21_, boolean isHighlands) {
        Random random = new Random(seed);
        int i = random.nextInt(p_227206_18_ / 2) + p_227206_18_ / 4;
        boolean flag = random.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        if (isHighlands && caveRadius < 6.0f) {
            caveRadius *= 2.0f;
        }
        for (int j = p_227206_17_; j < p_227206_18_; ++j) {
            double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)Math.PI * (float)j / (float)p_227206_18_)) * caveRadius);
            double d1 = d0 * p_227206_19_;
            float f2 = MathHelper.func_76134_b((float)p_227206_16_);
            randOffsetXCoord += (double)(MathHelper.func_76134_b((float)pitch) * f2);
            startY += (double)MathHelper.func_76126_a((float)p_227206_16_);
            randOffsetZCoord += (double)(MathHelper.func_76126_a((float)pitch) * f2);
            p_227206_16_ *= flag ? 0.92f : 0.7f;
            p_227206_16_ += f1 * 0.1f;
            pitch += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && caveRadius > 1.0f) {
                this.genNode(chunk, biomePos, random.nextLong(), seaLevel, chunkX, chunkZ, randOffsetXCoord, startY, randOffsetZCoord, random.nextFloat() * 0.5f + 0.5f, pitch - 1.5707964f, p_227206_16_ / 3.0f, j, p_227206_18_, 1.0, p_227206_21_, this.isHighlands);
                this.genNode(chunk, biomePos, random.nextLong(), seaLevel, chunkX, chunkZ, randOffsetXCoord, startY, randOffsetZCoord, random.nextFloat() * 0.5f + 0.5f, pitch + 1.5707964f, p_227206_16_ / 3.0f, j, p_227206_18_, 1.0, p_227206_21_, this.isHighlands);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(chunkX, chunkZ, randOffsetXCoord, randOffsetZCoord, j, p_227206_18_, caveRadius)) {
                return;
            }
            this.func_227208_a_(chunk, biomePos, seed, seaLevel, chunkX, chunkZ, randOffsetXCoord, startY, randOffsetZCoord, d0, d1, p_227206_21_);
        }
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return p_222708_3_ <= -0.7 || p_222708_1_ * p_222708_1_ + p_222708_3_ * p_222708_3_ + p_222708_5_ * p_222708_5_ >= 1.0;
    }

    protected boolean func_230358_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, BitSet carvingMask, Random rand, BlockPos.Mutable pos, BlockPos.Mutable posUp, BlockPos.Mutable posDown, int p_230358_8_, int p_230358_9_, int p_230358_10_, int posX, int posZ, int p_230358_13_, int posY, int p_230358_15_, MutableBoolean isSurface) {
        int i = p_230358_13_ | p_230358_15_ << 4 | posY << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        pos.func_181079_c(posX, posY, posZ);
        BlockState blockstate = chunk.func_180495_p((BlockPos)pos);
        BlockState blockstate1 = chunk.func_180495_p((BlockPos)posUp.func_239622_a_((Vector3i)pos, Direction.UP));
        if (blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_203425_a(Blocks.field_150391_bh)) {
            isSurface.setTrue();
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (posY < 6) {
            return false;
        }
        BlockState aboveSurface = chunk.func_180495_p((BlockPos)posUp.func_189533_g((Vector3i)pos.func_177982_a(0, 1, 0)));
        for (Direction facing : Direction.values()) {
            BlockState areaAround = chunk.func_180495_p(posUp.func_177972_a(facing));
            BlockState areaAboveAround = chunk.func_180495_p((BlockPos)posUp.func_189533_g((Vector3i)pos.func_177982_a(0, 1, 0).func_177972_a(facing)));
            if (rand.nextInt(10) == 0 && chunk.func_180495_p((BlockPos)pos).func_203425_a(Blocks.field_201941_jj) && chunk.func_180495_p(pos.func_177972_a(facing)).func_235714_a_((ITag)BlockTags.field_242172_aH) && this.isHighlands) {
                chunk.func_177436_a(pos.func_177972_a(facing), ((Block)TFBlocks.trollsteinn.get()).func_176223_P(), false);
            }
            if (aboveSurface.func_203425_a(Blocks.field_150355_j) || areaAround.func_203425_a(Blocks.field_150355_j) || areaAboveAround.func_203425_a(Blocks.field_150355_j)) continue;
            chunk.func_177436_a((BlockPos)pos, field_222715_g, false);
            if (chunk.func_180495_p(pos.func_177984_a()).func_235714_a_((ITag)BlockTags.field_242172_aH) && chunk.func_180495_p((BlockPos)pos).func_203425_a(Blocks.field_201941_jj) && !this.isHighlands) {
                chunk.func_177436_a(pos.func_177984_a(), Blocks.field_150346_d.func_176223_P(), false);
            }
            if (!isSurface.isTrue()) continue;
            posDown.func_239622_a_((Vector3i)pos, Direction.DOWN);
            if (!chunk.func_180495_p((BlockPos)posDown).func_203425_a(Blocks.field_150346_d)) continue;
            chunk.func_177436_a((BlockPos)posDown, biomePos.apply((BlockPos)pos).func_242440_e().func_242502_e().func_204108_a(), false);
        }
        return true;
    }

    protected boolean func_222707_a(BlockState state, BlockState aboveState) {
        return this.func_222706_a(state) || (state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a((Block)TFBlocks.trollsteinn.get()) || state.func_203425_a(Blocks.field_150351_n)) && !aboveState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

