/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import twilightforest.IMCHandler;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.world.feature.config.CaveStalactiteConfig;

public class TFGenCaveStalactite
extends Feature<CaveStalactiteConfig> {
    private static final List<StalactiteEntry> largeHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> mediumHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> smallHillStalactites = new ArrayList<StalactiteEntry>();

    public TFGenCaveStalactite(Codec<CaveStalactiteConfig> configIn) {
        super(configIn);
    }

    public static CaveStalactiteConfig makeRandomOreStalactite(Random rand, int hillSize) {
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.largeHillStalactites)).stalactite;
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.mediumHillStalactites)).stalactite;
        }
        return ((StalactiteEntry)WeightedRandom.func_76271_a((Random)rand, TFGenCaveStalactite.smallHillStalactites)).stalactite;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, CaveStalactiteConfig config) {
        Material m;
        int ty;
        int ceiling = Integer.MAX_VALUE;
        int floor = -1;
        BlockPos.Mutable iterPos = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        for (ty = pos.func_177956_o(); ty < 256; ++ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e) {
                return false;
            }
            ceiling = ty;
            break;
        }
        if (ceiling == Integer.MAX_VALUE) {
            return false;
        }
        for (ty = pos.func_177956_o(); ty > 4; --ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e && !config.hang && m != Material.field_151586_h && !config.hang && m != Material.field_151587_i) {
                return false;
            }
            floor = ty;
            break;
        }
        int length = (int)((float)(ceiling - floor) * config.sizeFactor * random.nextFloat());
        if (config.maxLength > -1 && length > config.maxLength) {
            length = config.maxLength;
        }
        if (config.minHeight > -1 && ceiling - floor - length < config.minHeight) {
            return false;
        }
        return this.makeSpike((IWorld)world, random, new BlockPos(pos.func_177958_n(), config.hang ? ceiling : floor, pos.func_177952_p()), length, config);
    }

    public boolean makeSpike(IWorld world, Random random, BlockPos pos, int maxLength, CaveStalactiteConfig config) {
        int diameter = (int)((double)maxLength / 4.5);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int dir;
                int absx = Math.abs(dx);
                int absz = Math.abs(dz);
                int dist = (int)((double)Math.max(absx, absz) + (double)Math.min(absx, absz) * 0.5);
                int spikeLength = 0;
                if (dist == 0) {
                    spikeLength = maxLength;
                }
                if (dist > 0) {
                    spikeLength = random.nextInt((int)((double)maxLength / ((double)dist + 0.25)));
                }
                int n = dir = config.hang ? -1 : 1;
                if (!world.func_180495_p(pos.func_177982_a(dx, -dir, dz)).func_185904_a().func_76220_a()) {
                    spikeLength = 0;
                }
                for (int dy = 0; dy != spikeLength * dir; dy += dir) {
                    this.func_230367_a_((IWorldWriter)world, pos.func_177982_a(dx, dy, dz), config.blockState);
                }
            }
        }
        return true;
    }

    public static void addStalactite(int hillSize, BlockState blockState, float size, int maxLength, int minHeight, int itemWeight) {
        if (itemWeight > 0) {
            TFGenCaveStalactite.addStalactite(hillSize, new StalactiteEntry(blockState, size, maxLength, minHeight, itemWeight));
        }
    }

    private static void addStalactite(int hillSize, StalactiteEntry entry) {
        if (hillSize <= 1) {
            smallHillStalactites.add(entry);
        }
        if (hillSize <= 2) {
            mediumHillStalactites.add(entry);
        }
        largeHillStalactites.add(entry);
    }

    private static void addDefaultStalactites() {
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150482_ag.func_176223_P(), 0.5f, 4, 16, 30);
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150369_x.func_176223_P(), 0.8f, 8, 1, 30);
        TFGenCaveStalactite.addStalactite(3, Blocks.field_150412_bA.func_176223_P(), 0.5f, 3, 12, 15);
        TFGenCaveStalactite.addStalactite(2, Blocks.field_150352_o.func_176223_P(), 0.6f, 6, 1, 20);
        TFGenCaveStalactite.addStalactite(2, Blocks.field_150450_ax.func_176223_P(), 0.8f, 8, 1, 40);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150366_p.func_176223_P(), 0.7f, 8, 1, 24);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150365_q.func_176223_P(), 0.8f, 12, 1, 24);
        TFGenCaveStalactite.addStalactite(1, Blocks.field_150426_aN.func_176223_P(), 0.5f, 8, 1, 12);
    }

    public static void loadStalactites() {
        smallHillStalactites.clear();
        mediumHillStalactites.clear();
        largeHillStalactites.clear();
        TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.load();
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.useConfigOnly.get()).booleanValue()) {
            if (smallHillStalactites.isEmpty()) {
                TwilightForestMod.LOGGER.info("Not all hollow hills are populated with the config, adding fallback");
                TFGenCaveStalactite.addStalactite(1, Blocks.field_150348_b.func_176223_P(), 0.7f, 8, 1, 1);
            }
            return;
        }
        TFGenCaveStalactite.addDefaultStalactites();
        IMCHandler.getStalactites().forEach(TFGenCaveStalactite::addStalactite);
    }

    public static class StalactiteEntry
    extends WeightedRandom.Item {
        final CaveStalactiteConfig stalactite;

        StalactiteEntry(CaveStalactiteConfig stalactite, int itemWeight) {
            super(itemWeight);
            this.stalactite = stalactite;
        }

        public StalactiteEntry(BlockState blockState, float size, int maxLength, int minHeight, int itemWeight) {
            this(new CaveStalactiteConfig(blockState, size, maxLength, minHeight, true), itemWeight);
        }
    }
}

