/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.biomes;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.TwilightForestMod;

public class BiomeKeys {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"twilightforest");
    public static final RegistryKey<Biome> FOREST = BiomeKeys.makeKey("forest");
    public static final RegistryKey<Biome> DENSE_FOREST = BiomeKeys.makeKey("dense_forest");
    public static final RegistryKey<Biome> FIREFLY_FOREST = BiomeKeys.makeKey("firefly_forest");
    public static final RegistryKey<Biome> CLEARING = BiomeKeys.makeKey("clearing");
    public static final RegistryKey<Biome> OAK_SAVANNAH = BiomeKeys.makeKey("oak_savannah");
    public static final RegistryKey<Biome> STREAM = BiomeKeys.makeKey("stream");
    public static final RegistryKey<Biome> LAKE = BiomeKeys.makeKey("lake");
    public static final RegistryKey<Biome> MUSHROOM_FOREST = BiomeKeys.makeKey("mushroom_forest");
    public static final RegistryKey<Biome> DENSE_MUSHROOM_FOREST = BiomeKeys.makeKey("dense_mushroom_forest");
    public static final RegistryKey<Biome> ENCHANTED_FOREST = BiomeKeys.makeKey("enchanted_forest");
    public static final RegistryKey<Biome> SPOOKY_FOREST = BiomeKeys.makeKey("spooky_forest");
    public static final RegistryKey<Biome> SWAMP = BiomeKeys.makeKey("swamp");
    public static final RegistryKey<Biome> FIRE_SWAMP = BiomeKeys.makeKey("fire_swamp");
    public static final RegistryKey<Biome> DARK_FOREST = BiomeKeys.makeKey("dark_forest");
    public static final RegistryKey<Biome> DARK_FOREST_CENTER = BiomeKeys.makeKey("dark_forest_center");
    public static final RegistryKey<Biome> SNOWY_FOREST = BiomeKeys.makeKey("snowy_forest");
    public static final RegistryKey<Biome> GLACIER = BiomeKeys.makeKey("glacier");
    public static final RegistryKey<Biome> HIGHLANDS = BiomeKeys.makeKey("highlands");
    public static final RegistryKey<Biome> THORNLANDS = BiomeKeys.makeKey("thornlands");
    public static final RegistryKey<Biome> FINAL_PLATEAU = BiomeKeys.makeKey("final_plateau");
    public static final BiomeDictionary.Type TWILIGHT = BiomeDictionary.Type.getType((String)"TWILIGHT", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);

    private static RegistryKey<Biome> makeKey(String name) {
        BIOMES.register(name, () -> new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(0.0f).func_205417_d(0.0f).func_205420_b(0.0f).func_205414_c(0.0f).func_235097_a_(new BiomeAmbience.Builder().func_235239_a_(0).func_235246_b_(0).func_235248_c_(0).func_242539_d(0).func_235238_a_()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242456_a(Biome.TemperatureModifier.NONE).func_242455_a());
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes(FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(DENSE_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes(FIREFLY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH});
        BiomeDictionary.addTypes(CLEARING, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes(OAK_SAVANNAH, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes(STREAM, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.RIVER});
        BiomeDictionary.addTypes(LAKE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.OCEAN});
        BiomeDictionary.addTypes(MUSHROOM_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.addTypes(DENSE_MUSHROOM_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.addTypes(ENCHANTED_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes(SPOOKY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes(SWAMP, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes(FIRE_SWAMP, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT});
        BiomeDictionary.addTypes(DARK_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes(DARK_FOREST_CENTER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes(SNOWY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes(GLACIER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes(HIGHLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes(THORNLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes(FINAL_PLATEAU, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
    }
}

