/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.biomes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import twilightforest.TFStructures;
import twilightforest.worldgen.ConfiguredSurfaceBuilders;
import twilightforest.worldgen.biomes.BiomeGrassColors;
import twilightforest.worldgen.biomes.BiomeHelper;
import twilightforest.worldgen.biomes.BiomeKeys;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<RegistryKey<Biome>, Biome> BIOMES = BiomeMaker.generateBiomes();

    private static Map<RegistryKey<Biome>, Biome> generateBiomes() {
        ImmutableMap.Builder biomes = ImmutableMap.builder();
        BiomeMaker.commonBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.mushroomBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.rareBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.swampBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.darkForestBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.snowRegionBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        BiomeMaker.highlandsBiomes((ImmutableMap.Builder<RegistryKey<Biome>, Biome>)biomes);
        return biomes.build();
    }

    private static void commonBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.twilightForestGen(BiomeMaker.defaultGenSettingBuilder())).func_242455_a());
        biomes.put(BiomeKeys.DENSE_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_235246_b_(21794), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.denseForestGen(BiomeMaker.defaultGenSettingBuilder())).func_205414_c(0.7f).func_205417_d(0.8f).func_205421_a(0.2f).func_205420_b(0.2f).func_242455_a());
        biomes.put(BiomeKeys.FIREFLY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.fireflyForestGen(BiomeMaker.defaultGenSettingBuilder())).func_205414_c(0.5f).func_205417_d(1.0f).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
        biomes.put(BiomeKeys.CLEARING, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.addDefaultStructures(BiomeMaker.defaultGenSettingBuilder())).func_205419_a(Biome.Category.PLAINS).func_205414_c(0.8f).func_205417_d(0.4f).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
        biomes.put(BiomeKeys.OAK_SAVANNAH, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.oakSavannaGen(BiomeMaker.defaultGenSettingBuilder())).func_205419_a(Biome.Category.SAVANNA).func_205414_c(0.9f).func_205417_d(0.0f).func_205421_a(0.2f).func_205420_b(0.2f).func_242455_a());
    }

    private static void mushroomBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.mushroomForestGen(BiomeMaker.defaultGenSettingBuilder())).func_205414_c(0.8f).func_205417_d(0.8f).func_242455_a());
        biomes.put(BiomeKeys.DENSE_MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning().func_242571_a(), BiomeMaker.denseMushroomForestGen(BiomeMaker.defaultGenSettingBuilder().func_242516_a(TFStructures.CONFIGURED_MUSHROOM_TOWER))).func_205414_c(0.8f).func_205417_d(1.0f).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
    }

    private static void rareBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SPOOKY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_242541_f(12865827).func_242540_e(16745729).func_235246_b_(16421137), BiomeMaker.spookSpawning(), BiomeMaker.spookyForestGen(BiomeMaker.defaultGenSettingBuilder())).func_205414_c(0.5f).func_205417_d(1.0f).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
        biomes.put(BiomeKeys.ENCHANTED_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_242540_e(65535).func_242541_f(65535).func_242537_a(BiomeGrassColors.ENCHANTED_FOREST), BiomeMaker.defaultMobSpawning(), BiomeMaker.enchantedForestGen(BiomeMaker.defaultGenSettingBuilder().func_242516_a(TFStructures.CONFIGURED_QUEST_GROVE))).func_242455_a());
        biomes.put(BiomeKeys.STREAM, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.defaultGenSettingBuilder()).func_205419_a(Biome.Category.RIVER).func_205414_c(0.5f).func_205417_d(0.1f).func_205421_a(-0.8f).func_205420_b(0.0f).func_242455_a());
        biomes.put(BiomeKeys.LAKE, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.defaultGenSettingBuilder()).func_205419_a(Biome.Category.OCEAN).func_205414_c(0.66f).func_205417_d(1.0f).func_205421_a(-1.8f).func_205420_b(0.1f).func_242455_a());
    }

    private static void swampBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_242541_f(6056270).func_242540_e(4809015).func_235246_b_(14745518).func_242537_a(BiomeGrassColors.SWAMP), BiomeMaker.swampSpawning(), BiomeMaker.swampGen(BiomeMaker.defaultGenSettingBuilder()).func_242516_a(TFStructures.CONFIGURED_LABYRINTH)).func_205419_a(Biome.Category.SWAMP).func_205414_c(0.8f).func_205417_d(0.9f).func_205421_a(-0.25f).func_205420_b(0.25f).func_242455_a());
        biomes.put(BiomeKeys.FIRE_SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.whiteAshParticles(BiomeMaker.defaultAmbientBuilder().func_242541_f(5713443).func_242540_e(6563343).func_235246_b_(0x6C2C2C)), new MobSpawnInfo.Builder(), BiomeMaker.fireSwampGen(BiomeMaker.defaultGenSettingBuilder()).func_242516_a(TFStructures.CONFIGURED_HYDRA_LAIR)).func_205419_a(Biome.Category.SWAMP).func_205414_c(1.0f).func_205417_d(0.4f).func_205421_a(0.1f).func_205420_b(0.2f).func_242455_a());
    }

    private static void darkForestBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.DARK_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_242541_f(4941652).func_242540_e(3890751).func_242537_a(BiomeGrassColors.DARK_FOREST), BiomeMaker.darkForestSpawning(), BiomeMaker.darkForestGen().func_242516_a(TFStructures.CONFIGURED_KNIGHT_STRONGHOLD)).func_205414_c(0.7f).func_205417_d(0.8f).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
        biomes.put(BiomeKeys.DARK_FOREST_CENTER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().func_242541_f(6714688).func_242540_e(16351774).func_242537_a(BiomeGrassColors.DARK_FOREST_CENTER), new MobSpawnInfo.Builder(), BiomeMaker.darkForestCenterGen().func_242516_a(TFStructures.CONFIGURED_DARK_TOWER)).func_205421_a(0.125f).func_205420_b(0.05f).func_242455_a());
    }

    private static void snowRegionBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SNOWY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.snowForestSpawning(), BiomeMaker.snowyForestGen().func_242516_a(TFStructures.CONFIGURED_YETI_CAVE)).func_205415_a(Biome.RainType.SNOW).func_205414_c(0.09f).func_205417_d(0.9f).func_205421_a(0.2f).func_205420_b(0.2f).func_242455_a());
        biomes.put(BiomeKeys.GLACIER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.penguinSpawning(), BiomeMaker.glacierGen().func_242516_a(TFStructures.CONFIGURED_AURORA_PALACE)).func_205419_a(Biome.Category.ICY).func_205414_c(0.8f).func_205417_d(0.1f).func_205415_a(Biome.RainType.SNOW).func_242455_a());
    }

    private static void highlandsBiomes(ImmutableMap.Builder<RegistryKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.HIGHLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.highlandsGen().func_242516_a(TFStructures.CONFIGURED_TROLL_CAVE)).func_205419_a(Biome.Category.MESA).func_205414_c(0.4f).func_205417_d(0.7f).func_205421_a(3.5f).func_205420_b(0.05f).func_242455_a());
        biomes.put(BiomeKeys.THORNLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), new MobSpawnInfo.Builder(), BiomeMaker.thornlandsGen()).func_205419_a(Biome.Category.NONE).func_205414_c(0.3f).func_205417_d(0.2f).func_205421_a(6.0f).func_205420_b(0.1f).func_242455_a());
        biomes.put(BiomeKeys.FINAL_PLATEAU, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.ravenSpawning(), BiomeMaker.defaultGenSettingBuilder().func_242517_a(ConfiguredSurfaceBuilders.CONFIGURED_PLATEAU).func_242516_a(TFStructures.CONFIGURED_FINAL_CASTLE)).func_205419_a(Biome.Category.MESA).func_205414_c(0.3f).func_205417_d(0.2f).func_205421_a(10.5f).func_205420_b(0.025f).func_242455_a());
    }
}

