/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import twilightforest.worldgen.TwilightFeatures;

public class TreeCorePlacer
extends TreeDecorator {
    public static final Codec<TreeCorePlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)20).fieldOf("core_position").forGetter(o -> o.corePos), (App)BlockStateProvider.field_236796_a_.fieldOf("deco_provider").forGetter(o -> o.core)).apply((Applicative)instance, TreeCorePlacer::new));
    private final int corePos;
    private final BlockStateProvider core;

    public TreeCorePlacer(int corePos, BlockStateProvider core) {
        this.corePos = corePos;
        this.core = core;
    }

    protected TreeDecoratorType<TreeCorePlacer> func_230380_a_() {
        return TwilightFeatures.CORE_PLACER;
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks, Set<BlockPos> decorations, MutableBoundingBox mutableBoundingBox) {
        BlockPos pos = trunkBlocks.get(0);
        BlockPos position = pos.func_177982_a(0, this.corePos, 0);
        this.placeCore(world, random, position, decorations, 0.0, this.corePos, 0, mutableBoundingBox, this.core);
    }

    public void placeCore(ISeedReader world, Random random, BlockPos pos, Set<BlockPos> decorations, double offset, int iteration, int length, MutableBoundingBox mutableBoundingBox, BlockStateProvider coreType) {
        BlockPos position = pos.func_177982_a(0, this.corePos, 0);
        this.func_227423_a_((IWorldWriter)world, pos, coreType.func_225574_a_(random, position), decorations, mutableBoundingBox);
    }
}

