/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.TFTreeGenerator;
import twilightforest.worldgen.TwilightFeatures;

public class TreeRootsDecorator
extends TreeDecorator {
    public static final Codec<TreeRootsDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_strand_count").forGetter(o -> o.strands), (App)Codec.intRange((int)0, (int)16).fieldOf("additional_random_strands").forGetter(o -> o.addExtraStrands), (App)Codec.intRange((int)0, (int)32).fieldOf("root_length").forGetter(o -> o.length), (App)BlockStateProvider.field_236796_a_.optionalFieldOf("air_roots_provider").forGetter(o -> Optional.ofNullable(o.surfaceBlock)), (App)BlockStateProvider.field_236796_a_.fieldOf("ground_roots_provider").forGetter(o -> o.rootBlock)).apply((Applicative)instance, TreeRootsDecorator::new));
    private final int strands;
    private final int addExtraStrands;
    private final int length;
    private final BlockStateProvider surfaceBlock;
    private final BlockStateProvider rootBlock;
    private final boolean hasSurfaceRoots;

    private TreeRootsDecorator(int count, int addExtraStrands, int length, Optional<BlockStateProvider> surfaceBlock, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = surfaceBlock.isPresent();
        this.surfaceBlock = this.hasSurfaceRoots ? surfaceBlock.get() : null;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = false;
        this.surfaceBlock = null;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, BlockStateProvider surfaceBlock, BlockStateProvider rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = true;
        this.surfaceBlock = surfaceBlock;
    }

    protected TreeDecoratorType<TreeRootsDecorator> func_230380_a_() {
        return TwilightFeatures.TREE_ROOTS;
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks, Set<BlockPos> decorations, MutableBoundingBox mutableBoundingBox) {
        if (trunkBlocks.isEmpty()) {
            return;
        }
        int numBranches = this.strands + random.nextInt(this.addExtraStrands + 1);
        float offset = random.nextFloat();
        BlockPos startPos = trunkBlocks.get(0);
        if (this.hasSurfaceRoots) {
            for (int i = 0; i < numBranches; ++i) {
                this.buildRootWithAir(world, random, startPos, decorations, offset, i, this.length, mutableBoundingBox, this.surfaceBlock, this.rootBlock);
            }
        } else {
            for (int i = 0; i < numBranches; ++i) {
                this.buildRoot(world, random, startPos, decorations, offset, i, this.length, mutableBoundingBox, this.rootBlock);
            }
        }
    }

    protected void buildRootWithAir(ISeedReader world, Random random, BlockPos pos, Set<BlockPos> decorations, double offset, int iteration, int length, MutableBoundingBox mutableBoundingBox, BlockStateProvider airRoot, BlockStateProvider dirtRoot) {
        BlockPos dest = FeatureUtil.translate(pos.func_177979_c(iteration + 2), length, 0.3 * (double)iteration + offset, 0.8);
        BlockPos[] lineArray = FeatureUtil.getBresenhamArrays(pos.func_177977_b(), dest);
        boolean stillAboveGround = true;
        for (BlockPos coord : lineArray) {
            if (stillAboveGround && FeatureUtil.hasAirAround((IWorld)world, coord)) {
                this.func_227423_a_((IWorldWriter)world, coord, airRoot.func_225574_a_(random, coord), decorations, mutableBoundingBox);
                continue;
            }
            stillAboveGround = false;
            if (!TFTreeGenerator.canRootGrowIn((IWorldReader)world, coord)) continue;
            this.func_227423_a_((IWorldWriter)world, coord, dirtRoot.func_225574_a_(random, coord), decorations, mutableBoundingBox);
        }
    }

    protected void buildRoot(ISeedReader world, Random random, BlockPos pos, Set<BlockPos> decorations, double offset, int iteration, int length, MutableBoundingBox mutableBoundingBox, BlockStateProvider dirtRoot) {
        BlockPos[] lineArray;
        BlockPos dest = FeatureUtil.translate(pos.func_177979_c(iteration + 2), length, 0.3 * (double)iteration + offset, 0.8);
        for (BlockPos coord : lineArray = FeatureUtil.getBresenhamArrays(pos.func_177977_b(), dest)) {
            if (!TFTreeGenerator.canRootGrowIn((IWorldReader)world, coord)) continue;
            this.func_227423_a_((IWorldWriter)world, coord, dirtRoot.func_225574_a_(random, coord), decorations, mutableBoundingBox);
        }
    }
}

