/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.debug;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.UUID;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flights;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="wings")
public final class DebugFlightAnimation {
    private static State state = new DisabledState();

    private DebugFlightAnimation() {
    }

    @SubscribeEvent
    public static void init(ModelRegistryEvent event) {
        state = state.init();
    }

    private static final class Handler {
        private static final GameProfile PROFILE = new GameProfile(UUID.fromString("617ab577-0da7-4d6a-a80d-0b516544369d"), "ModDeveloper");
        private PlayerEntity player;

        private Handler() {
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.func_71410_x();
                ClientWorld world = mc.field_71441_e;
                if (world != null && (this.player == null || this.player.field_70170_p != world)) {
                    this.player = new RemoteClientPlayerEntity(world, PROFILE){
                        {
                            super(x0, x1);
                            this.func_184212_Q().func_187227_b(field_184827_bp, (Object)-1);
                        }
                    };
                    this.player.func_145769_d(-this.player.func_145782_y());
                    this.player.func_70107_b(0.0, 62.0, 0.0);
                    this.player.field_70166_s = -1.0;
                    this.player.field_70167_r = 63.0;
                    this.player.func_195064_c(new EffectInstance((Effect)WingsEffects.WINGS.get()));
                    Flights.get(this.player).ifPresent(flight -> flight.setIsFlying(true));
                    Int2ObjectMap entities = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ClientWorld.class, (Object)world, (String)"entitiesById");
                    entities.put(this.player.func_145782_y(), (Object)this.player);
                }
                if (this.player != null && mc.func_147114_u() != null) {
                    ++this.player.field_70173_aa;
                    this.player.func_70071_h_();
                }
            }
        }

        @SubscribeEvent
        public void render(RenderWorldLastEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && mc.field_71439_g != null && mc.field_175622_Z != null) {
                EntityRendererManager manager = mc.func_175598_ae();
                Vector3d projectedView = mc.field_71460_t.func_215316_n().func_216785_c();
                manager.func_229084_a_((Entity)this.player, this.player.func_226277_ct_() - projectedView.func_82615_a(), this.player.func_226278_cu_() - projectedView.func_82617_b(), this.player.func_226281_cx_() - projectedView.func_82616_c(), 0.0f, event.getPartialTicks(), event.getMatrixStack(), (IRenderTypeBuffer)mc.func_228019_au_().func_228487_b_(), manager.func_229085_a_((Entity)this.player, event.getPartialTicks()));
            }
        }
    }

    private static final class EnableState
    implements State {
        private EnableState() {
        }

        @Override
        public State init() {
            MinecraftForge.EVENT_BUS.register((Object)new Handler());
            return new EnabledState();
        }
    }

    private static final class EnabledState
    implements State {
        private EnabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }

    protected static final class DisabledState
    implements State {
        protected DisabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }

    private static interface State {
        public State init();
    }
}

