/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server;

import com.mojang.brigadier.CommandDispatcher;
import me.paulf.wings.server.asm.GetLivingHeadLimitEvent;
import me.paulf.wings.server.asm.PlayerFlightCheckEvent;
import me.paulf.wings.server.asm.PlayerFlownEvent;
import me.paulf.wings.server.command.WingsCommand;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings")
public final class ServerEventHandler {
    private ServerEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        if (event.getTarget() instanceof BatEntity && stack.func_77973_b() == Items.field_151069_bo) {
            player.field_70170_p.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ItemStack destroyed = stack.func_77946_l();
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_151069_bo));
            ItemStack batBlood = new ItemStack((IItemProvider)WingsItems.BAT_BLOOD_BOTTLE.get());
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)destroyed, (Hand)hand);
                player.func_184611_a(hand, batBlood);
            } else if (!player.field_71071_by.func_70441_a(batBlood)) {
                player.func_71019_a(batBlood, false);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        if (event.isMounting()) {
            Flights.ifPlayer(event.getEntityMounting(), (player, flight) -> {
                if (flight.isFlying()) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Flights.get(event.player).ifPresent(flight -> flight.tick(event.player));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Flights.ifPlayer((Entity)event.getEntityLiving(), (player, flight) -> flight.setIsFlying(false, Flight.PlayerSet.ofAll()));
    }

    @SubscribeEvent
    public static void onPlayerFlightCheck(PlayerFlightCheckEvent event) {
        Flights.get(event.getPlayer()).filter(Flight::isFlying).ifPresent(flight -> event.setFlying());
    }

    @SubscribeEvent
    public static void onPlayerFlown(PlayerFlownEvent event) {
        PlayerEntity player = event.getPlayer();
        Flights.get(player).ifPresent(flight -> flight.onFlown(player, event.getDirection()));
    }

    @SubscribeEvent
    public static void onGetLivingHeadLimit(GetLivingHeadLimitEvent event) {
        Flights.ifPlayer((Entity)event.getEntityLiving(), (player, flight) -> {
            if (flight.isFlying()) {
                event.setHardLimit(50.0f);
                event.disableSoftLimit();
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        WingsCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

