/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.apparatus;

import java.util.Objects;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingSettings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;

public final class SimpleFlightApparatus
implements FlightApparatus {
    private final WingSettings settings;

    public SimpleFlightApparatus(WingSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public void onFlight(PlayerEntity player, Vector3d direction) {
        int distance = Math.round((float)direction.func_72433_c() * 100.0f);
        if (distance > 0) {
            player.func_71020_j((float)distance * this.settings.getFlyingExertion());
        }
    }

    @Override
    public void onLanding(PlayerEntity player, Vector3d direction) {
        player.func_71020_j(this.settings.getLandingExertion());
    }

    @Override
    public boolean isUsable(PlayerEntity player) {
        return player.func_71024_bL().func_75116_a() >= this.settings.getRequiredFlightSatiation();
    }

    @Override
    public boolean isLandable(PlayerEntity player) {
        return player.func_71024_bL().func_75116_a() >= this.settings.getRequiredLandSatiation();
    }

    @Override
    public FlightApparatus.FlightState createState(Flight flight) {
        return player -> {};
    }
}

