/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.asm;

import me.paulf.wings.server.asm.GetCameraEyeHeightEvent;
import me.paulf.wings.server.asm.GetLivingHeadLimitEvent;
import me.paulf.wings.server.asm.PlayerFlightCheckEvent;
import me.paulf.wings.server.asm.PlayerFlownEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class WingsHooks {
    private WingsHooks() {
    }

    public static boolean onFlightCheck(LivingEntity living, boolean defaultValue) {
        return living instanceof PlayerEntity && WingsHooks.onFlightCheck((PlayerEntity)living, defaultValue);
    }

    public static boolean onFlightCheck(PlayerEntity player, boolean defaultValue) {
        if (defaultValue) {
            return true;
        }
        PlayerFlightCheckEvent ev = new PlayerFlightCheckEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.isFlying();
    }

    public static float onGetCameraEyeHeight(Entity entity, float eyeHeight) {
        GetCameraEyeHeightEvent ev = GetCameraEyeHeightEvent.create(entity, eyeHeight);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static boolean onUpdateBodyRotation(LivingEntity living, float movementYaw) {
        GetLivingHeadLimitEvent ev = GetLivingHeadLimitEvent.create(living);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        if (ev.isVanilla()) {
            return false;
        }
        living.field_70761_aq += MathHelper.func_76142_g((float)(movementYaw - living.field_70761_aq)) * 0.3f;
        float hLimit = ev.getHardLimit();
        float sLimit = ev.getSoftLimit();
        float theta = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(living.field_70177_z - living.field_70761_aq)), (float)(-hLimit), (float)hLimit);
        living.field_70761_aq = living.field_70177_z - theta;
        if (theta * theta > sLimit * sLimit) {
            living.field_70761_aq += theta * 0.2f;
        }
        return true;
    }

    public static void onAddFlown(PlayerEntity player, double x, double y, double z) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerFlownEvent(player, new Vector3d(x, y, z)));
    }

    public static boolean onReplaceItemSlotCheck(Item item, ItemStack stack) {
        return item instanceof ElytraItem || item.getEquipmentSlot(stack) != null;
    }
}

