/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.dreamcatcher;

import java.util.function.IntConsumer;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class InSomniable {
    private State state;

    public InSomniable() {
        this(new SearchState());
    }

    private InSomniable(State state) {
        this.state = state;
    }

    public void onPlay(World world, PlayerEntity player, BlockPos pos, int note) {
        this.state = this.state.onPlay(world, player, pos, note);
    }

    public void clone(InSomniable other) {
        this.state = other.state.copy();
    }

    public static final class Serializer
    implements NBTSerializer<InSomniable, CompoundNBT> {
        private static final String SEARCH_STATE = "SearchState";

        @Override
        public CompoundNBT serialize(InSomniable instance) {
            CompoundNBT compound = new CompoundNBT();
            instance.state.ifSearching(state -> compound.func_74768_a(SEARCH_STATE, state));
            return compound;
        }

        @Override
        public InSomniable deserialize(CompoundNBT compound) {
            State state = compound.func_150297_b(SEARCH_STATE, 3) ? new SearchState(compound.func_74762_e(SEARCH_STATE)) : InSomniacState.INSTANCE;
            return new InSomniable(state);
        }
    }

    private static final class InSomniacState
    implements State {
        private static final State INSTANCE = new InSomniacState();

        private InSomniacState() {
        }

        @Override
        public State onPlay(World world, PlayerEntity player, BlockPos pos, int note) {
            return this;
        }

        @Override
        public State copy() {
            return this;
        }

        @Override
        public void ifSearching(IntConsumer consumer) {
        }
    }

    private static final class SearchState
    implements State {
        private final int[] mask = new int[]{49086, 65533, 65535, 52547, 65535, 32511, 65535, 63487, 64511};
        private final String[] members = new String[]{"wings.dreamcatcher.jiu", "wings.dreamcatcher.sua", "wings.dreamcatcher.siyeon", "wings.dreamcatcher.handong", "wings.dreamcatcher.yoohyeon", "wings.dreamcatcher.dami", "wings.dreamcatcher.gahyeon"};
        private int state;

        private SearchState() {
            this(131070);
        }

        private SearchState(int state) {
            this.state = state;
        }

        @Override
        public State onPlay(World world, PlayerEntity player, BlockPos pos, int note) {
            if (note >= 6 && note <= 14 && ((this.state = (this.state | this.mask[note - 6]) << 1) & 0x20000) == 0) {
                ItemStack stack = new ItemStack((IItemProvider)WingsItems.ANGEL_WINGS_BOTTLE.get());
                stack.func_200302_a((ITextComponent)new TranslationTextComponent(this.members[world.field_73012_v.nextInt(this.members.length)]));
                ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.25, (double)pos.func_177952_p() + 0.5, stack);
                entity.func_174869_p();
                world.func_217376_c((Entity)entity);
                return InSomniacState.INSTANCE;
            }
            return this;
        }

        @Override
        public State copy() {
            return new SearchState(this.state);
        }

        @Override
        public void ifSearching(IntConsumer consumer) {
            consumer.accept(this.state);
        }
    }

    private static interface State {
        public State onPlay(World var1, PlayerEntity var2, BlockPos var3, int var4);

        public State copy();

        public void ifSearching(IntConsumer var1);
    }
}

