/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.util.CubicBezier;
import me.paulf.wings.util.Mth;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public final class FlightDefault
implements Flight {
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private final List<Flight.FlyingListener> flyingListeners = Lists.newArrayList();
    private final List<Flight.SyncListener> syncListeners = Lists.newArrayList();
    private final WingState voidState = new WingState(FlightApparatus.NONE, FlightApparatus.FlightState.NONE);
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private FlightApparatus flightApparatus = FlightApparatus.NONE;
    private WingState state = this.voidState;

    @Override
    public void setIsFlying(boolean isFlying, Flight.PlayerSet players) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            this.flyingListeners.forEach(Flight.FlyingListener.onChangeUsing(isFlying));
            this.sync(players);
        }
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public void setTimeFlying(int timeFlying) {
        this.timeFlying = timeFlying;
    }

    @Override
    public int getTimeFlying() {
        return this.timeFlying;
    }

    @Override
    public void setWing(FlightApparatus wing, Flight.PlayerSet players) {
        Objects.requireNonNull(wing);
        if (this.flightApparatus != wing) {
            this.flightApparatus = wing;
            this.sync(players);
        }
    }

    @Override
    public FlightApparatus getWing() {
        return this.flightApparatus;
    }

    @Override
    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(Mth.lerp(this.getPrevTimeFlying(), this.getTimeFlying(), delta) / 20.0f);
    }

    private void setPrevTimeFlying(int prevTimeFlying) {
        this.prevTimeFlying = prevTimeFlying;
    }

    private int getPrevTimeFlying() {
        return this.prevTimeFlying;
    }

    @Override
    public void registerFlyingListener(Flight.FlyingListener listener) {
        this.flyingListeners.add(listener);
    }

    @Override
    public void registerSyncListener(Flight.SyncListener listener) {
        this.syncListeners.add(listener);
    }

    @Override
    public boolean canFly(PlayerEntity player) {
        return this.hasEffect(player) && this.flightApparatus.isUsable(player);
    }

    private boolean hasEffect(PlayerEntity player) {
        return WingsEffects.WINGS.filter(effect -> player.func_70660_b(effect) != null).isPresent();
    }

    @Override
    public boolean canLand(PlayerEntity player) {
        return this.flightApparatus.isLandable(player);
    }

    private void onWornUpdate(PlayerEntity player) {
        if (player.func_70613_aW()) {
            if (this.isFlying()) {
                float speed = (float)MathHelper.func_151238_b((double)0.03f, (double)0.0715f, (double)player.field_191988_bg);
                float elevationBoost = Mth.transform(Math.abs(player.field_70125_A), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -Mth.toRadians(player.field_70125_A - 30.0f * elevationBoost);
                float yaw = -Mth.toRadians(player.field_70177_z) - (float)Math.PI;
                float vxz = -MathHelper.func_76134_b((float)pitch);
                float vy = MathHelper.func_76126_a((float)pitch);
                float vz = MathHelper.func_76134_b((float)yaw);
                float vx = MathHelper.func_76126_a((float)yaw);
                player.func_213317_d(player.func_213322_ci().func_72441_c((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.field_70125_A > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
            }
            if (this.canLand(player)) {
                Vector3d mot = player.func_213322_ci();
                if (mot.func_82617_b() < 0.0) {
                    player.func_213317_d(mot.func_216372_d(1.0, (double)0.9f, 1.0));
                }
                player.field_70143_R = 0.0f;
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            if (this.flightApparatus.isUsable(player)) {
                this.state = this.state.next(this.flightApparatus);
                this.state.onUpdate(player);
            } else if (this.isFlying()) {
                this.setIsFlying(false, Flight.PlayerSet.ofAll());
                this.state = this.state.notFlying();
            }
        }
    }

    @Override
    public void tick(PlayerEntity player) {
        if (this.hasEffect(player) || !player.func_70613_aW()) {
            this.onWornUpdate(player);
        } else if (!player.field_70170_p.field_72995_K) {
            this.setWing(FlightApparatus.NONE, Flight.PlayerSet.ofAll());
            if (this.isFlying()) {
                this.setIsFlying(false, Flight.PlayerSet.ofAll());
            }
        }
        this.setPrevTimeFlying(this.getTimeFlying());
        if (this.isFlying()) {
            if (this.getTimeFlying() < 20) {
                this.setTimeFlying(this.getTimeFlying() + 1);
            } else if (player.func_175144_cb() && player.func_233570_aj_()) {
                this.setIsFlying(false, Flight.PlayerSet.ofOthers());
            }
        } else if (this.getTimeFlying() > 0) {
            this.setTimeFlying(this.getTimeFlying() - 1);
        }
    }

    @Override
    public void onFlown(PlayerEntity player, Vector3d direction) {
        if (this.isFlying()) {
            this.flightApparatus.onFlight(player, direction);
        } else if (player.func_213322_ci().func_82617_b() < -0.5) {
            this.flightApparatus.onLanding(player, direction);
        }
    }

    @Override
    public void clone(Flight other) {
        this.setIsFlying(other.isFlying());
        this.setTimeFlying(other.getTimeFlying());
        this.setWing(other.getWing());
    }

    @Override
    public void sync(Flight.PlayerSet players) {
        this.syncListeners.forEach(Flight.SyncListener.onSyncUsing(players));
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeBoolean(this.isFlying());
        buf.func_150787_b(this.getTimeFlying());
        buf.func_180714_a(WingsMod.WINGS.func_177774_c((Object)this.getWing()).toString());
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.setIsFlying(buf.readBoolean());
        this.setTimeFlying(buf.func_150792_a());
        this.setWing((FlightApparatus)WingsMod.WINGS.func_82594_a(ResourceLocation.func_208304_a((String)buf.func_150789_c(64))));
    }

    private final class WingState {
        private final FlightApparatus apparatus;
        private final FlightApparatus.FlightState activity;

        private WingState(FlightApparatus apparatus, FlightApparatus.FlightState activity) {
            this.apparatus = apparatus;
            this.activity = activity;
        }

        private WingState notFlying() {
            return FlightDefault.this.voidState;
        }

        private WingState next(FlightApparatus wf) {
            if (this.apparatus.equals(wf)) {
                return this;
            }
            return new WingState(wf, wf.createState(FlightDefault.this));
        }

        private void onUpdate(PlayerEntity player) {
            this.activity.onUpdate(player);
        }
    }

    public static final class Serializer
    implements NBTSerializer<FlightDefault, CompoundNBT> {
        private static final String IS_FLYING = "isFlying";
        private static final String TIME_FLYING = "timeFlying";
        private static final String WING = "wing";
        private final Supplier<FlightDefault> factory;

        public Serializer(Supplier<FlightDefault> factory) {
            this.factory = factory;
        }

        @Override
        public CompoundNBT serialize(FlightDefault instance) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74757_a(IS_FLYING, instance.isFlying());
            compound.func_74768_a(TIME_FLYING, instance.getTimeFlying());
            compound.func_74778_a(WING, WingsMod.WINGS.func_177774_c((Object)instance.getWing()).toString());
            return compound;
        }

        @Override
        public FlightDefault deserialize(CompoundNBT compound) {
            FlightDefault f = this.factory.get();
            f.setIsFlying(compound.func_74767_n(IS_FLYING));
            f.setTimeFlying(compound.func_74762_e(TIME_FLYING));
            f.setWing((FlightApparatus)WingsMod.WINGS.func_82594_a(ResourceLocation.func_208304_a((String)compound.func_74779_i(WING))));
            return f;
        }
    }
}

