/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.flight.AttachFlightCapabilityEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.FlightDefault;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings")
public final class Flights {
    private static final CapabilityHolder<PlayerEntity, Flight, CapabilityHolder.State<PlayerEntity, Flight>> HOLDER = CapabilityHolder.create();

    private Flights() {
    }

    public static boolean has(PlayerEntity player) {
        return HOLDER.state().has(player, null);
    }

    public static LazyOptional<Flight> get(PlayerEntity player) {
        return HOLDER.state().get(player, null);
    }

    @CapabilityInject(value=Flight.class)
    static void inject(Capability<Flight> capability) {
        HOLDER.inject(capability);
    }

    public static void ifPlayer(Entity entity, BiConsumer<PlayerEntity, Flight> action) {
        Flights.ifPlayer(entity, e -> true, action);
    }

    public static void ifPlayer(Entity entity, Predicate<PlayerEntity> condition, BiConsumer<PlayerEntity, Flight> action) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Flights.get(player).filter(f -> condition.test(player)).ifPresent(f -> action.accept(player, (Flight)f));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            Supplier<FlightDefault> factory = () -> {
                FlightDefault flight = new FlightDefault();
                WingsMod.instance().addFlightListeners((PlayerEntity)entity, flight);
                return flight;
            };
            FlightDefault flight = factory.get();
            event.addCapability(new ResourceLocation("wings", "flight"), HOLDER.state().providerBuilder(flight).serializedBy(new FlightDefault.Serializer(factory)).build());
            MinecraftForge.EVENT_BUS.post((Event)AttachFlightCapabilityEvent.create(event, flight));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Flights.get(event.getOriginal()).ifPresent(oldInstance -> Flights.get(event.getPlayer()).ifPresent(newInstance -> newInstance.clone((Flight)oldInstance)));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Flights.get(event.getPlayer()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Flights.get(event.getPlayer()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Flights.get(event.getPlayer()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Flights.ifPlayer(event.getTarget(), (player, flight) -> flight.sync(Flight.PlayerSet.ofPlayer((ServerPlayerEntity)event.getPlayer())));
    }
}

