/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.entity.layer;

import com.magistuarmory.client.render.entity.layer.PatternLayer;
import com.magistuarmory.client.render.model.ArmorDecorationModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorDecorationLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends ArmorDecorationModel<T>>
extends RenderLayer<T, M>
implements PatternLayer {
    private static final String BASE_DIR = "textures/models/armor/";
    private final A model;
    private final ResourceLocation baseTexture;
    private final String name;
    private final String dir;

    public ArmorDecorationLayer(RenderLayerParent<T, M> parent, A model, ResourceLocation texture, String name) {
        super(parent);
        this.model = model;
        this.baseTexture = texture;
        this.name = name;
        this.dir = BASE_DIR + name + "/";
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int p, T entity, float f, float f2, float f3, float f4, float f5, float f6) {
        this.renderArmorPiece(pose, buffer, entity, EquipmentSlot.CHEST, p, this.getArmorDecorationModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(pose, buffer, entity, EquipmentSlot.LEGS, p, this.getArmorDecorationModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(pose, buffer, entity, EquipmentSlot.FEET, p, this.getArmorDecorationModel(EquipmentSlot.FEET));
        this.renderArmorPiece(pose, buffer, entity, EquipmentSlot.HEAD, p, this.getArmorDecorationModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack pose, MultiBufferSource buffer, T entity, EquipmentSlot slot, int p, A model) {
        ArmorItem armoritem;
        ItemStack itemstack = entity.m_6844_(slot);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == slot) {
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            this.setPartVisibility(model, slot);
            boolean flag1 = itemstack.m_41790_();
            if (itemstack.m_41737_("BlockEntityTag") != null) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemstack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemstack));
                this.renderPatterns(pose, buffer, p, OverlayTexture.f_118083_, list, flag1, model);
            }
        }
    }

    protected void setPartVisibility(A model, EquipmentSlot slot) {
        model.m_8009_(false);
        switch (slot) {
            case HEAD: {
                ((ArmorDecorationModel)((Object)model)).f_102808_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)model)).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((ArmorDecorationModel)((Object)model)).f_102810_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)model)).f_102811_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)model)).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: 
            case FEET: {
                ((ArmorDecorationModel)((Object)model)).f_102813_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)model)).f_102814_.f_104207_ = true;
            }
        }
    }

    private A getArmorDecorationModel(EquipmentSlot slot) {
        return this.model;
    }

    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    public void renderPatterns(PoseStack pose, MultiBufferSource buffer, int p, int overlay, List<Pair<BannerPattern, DyeColor>> list, boolean hasfoil, A model) {
        this.renderPatterns(pose, buffer, p, overlay, list, hasfoil, ((ArmorDecorationModel)((Object)model)).getParts(), 1.0f, 1.0f, 1.0f, this.dir, this.getBaseTexture());
    }
}

