/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.client.render.model.item.BucklerModel;
import com.magistuarmory.client.render.model.item.CorruptedRoundShieldModel;
import com.magistuarmory.client.render.model.item.EllipticalShieldModel;
import com.magistuarmory.client.render.model.item.HeaterShieldModel;
import com.magistuarmory.client.render.model.item.KiteShieldModel;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.model.item.PaviseModel;
import com.magistuarmory.client.render.model.item.RondacheModel;
import com.magistuarmory.client.render.model.item.RoundShieldModel;
import com.magistuarmory.client.render.model.item.TargeModel;
import com.magistuarmory.client.render.model.item.TartscheModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeraldryItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final Map<String, Model> models = new HashMap<String, Model>();
    private final Model model;
    private final Material materialPattern;
    private final Material materialNoPattern;
    private final String patternsDirectory;

    public HeraldryItemStackRenderer(String id, String name, Model model) {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.model = model;
        this.materialPattern = new Material(TextureAtlas.f_118259_, new ResourceLocation("magistuarmory", "entity/" + id + "_pattern"));
        this.materialNoPattern = new Material(TextureAtlas.f_118259_, new ResourceLocation("magistuarmory", "entity/" + id + "_nopattern"));
        this.patternsDirectory = "entity/" + name + "/";
    }

    public void m_6213_(ResourceManager p_172555_) {
        super.m_6213_(p_172555_);
    }

    public void m_108829_(ItemStack p_108830_, ItemTransforms.TransformType p_108831_, PoseStack p_108832_, MultiBufferSource p_108833_, int p_108834_, int p_108835_) {
        if (this.model instanceof MedievalShieldModel) {
            MedievalShieldModel shieldmodel = (MedievalShieldModel)this.model;
            boolean flag = p_108830_.m_41737_("BlockEntityTag") != null;
            p_108832_.m_85836_();
            p_108832_.m_85841_(1.0f, -1.0f, -1.0f);
            Material material = flag ? this.materialPattern : this.materialNoPattern;
            VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)this.model.m_103119_(material.m_119193_()), (boolean)true, (boolean)p_108830_.m_41790_()));
            shieldmodel.handle().m_104306_(p_108832_, vertexconsumer, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (flag) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)p_108830_), (ListTag)BannerBlockEntity.m_58487_((ItemStack)p_108830_));
                this.renderPatterns(p_108832_, p_108833_, p_108834_, p_108835_, shieldmodel.plate(), material, list, p_108830_.m_41790_());
            } else {
                shieldmodel.plate().m_104306_(p_108832_, vertexconsumer, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            p_108832_.m_85849_();
        }
    }

    public void renderPatterns(PoseStack p_112075_, MultiBufferSource p_112076_, int p_112077_, int p_112078_, ModelPart p_112079_, Material p_112080_, List<Pair<BannerPattern, DyeColor>> p_112082_, boolean p_112083_) {
        p_112079_.m_104301_(p_112075_, p_112080_.m_119197_(p_112076_, RenderType::m_110452_, p_112083_), p_112077_, p_112078_);
        for (int i = 0; i < 17 && i < p_112082_.size(); ++i) {
            Pair<BannerPattern, DyeColor> pair = p_112082_.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).m_41068_();
            BannerPattern bannerpattern = (BannerPattern)pair.getFirst();
            Material material = new Material(Sheets.f_110738_, new ResourceLocation("magistuarmory", this.patternsDirectory + bannerpattern.m_58572_()));
            p_112079_.m_104306_(p_112075_, material.m_119194_(p_112076_, RenderType::m_110482_), p_112077_, p_112078_, afloat[0], afloat[1], afloat[2], 1.0f);
        }
    }

    static {
        models.put("heatershield", new HeaterShieldModel(HeaterShieldModel.createLayer().m_171564_()));
        models.put("pavese", new PaviseModel(PaviseModel.createLayer().m_171564_()));
        models.put("roundshield", new RoundShieldModel(RoundShieldModel.createLayer().m_171564_()));
        models.put("ellipticalshield", new EllipticalShieldModel(EllipticalShieldModel.createLayer().m_171564_()));
        models.put("tartsche", new TartscheModel(TartscheModel.createLayer().m_171564_()));
        models.put("rondache", new RondacheModel(RondacheModel.createLayer().m_171564_()));
        models.put("kiteshield", new KiteShieldModel(KiteShieldModel.createLayer().m_171564_()));
        models.put("buckler", new BucklerModel(BucklerModel.createLayer().m_171564_()));
        models.put("target", new TargeModel(TargeModel.createLayer().m_171564_()));
        models.put("corruptedroundshield", new CorruptedRoundShieldModel(CorruptedRoundShieldModel.createLayer().m_171564_()));
    }
}

