/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.magistuarmory.KnightlyArmory;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.network.PacketLongReachAttack;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSource;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MedievalWeaponItem
extends SwordItem
implements IHasModelProperty {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public final WeaponType type;
    protected final float attackDamage;
    protected final float attackSpeed;
    private final float decreasedAttackDamage;
    private final float decreasedAttackSpeed;
    private boolean isSilver = false;
    private float silverAttackDamage = 0.0f;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(Item.Properties properties, ModItemTier material, WeaponType type) {
        super((Tier)material, (int)CombatHelper.getBaseAttackDamage(material, type), CombatHelper.getBaseAttackSpeed(material, type), properties.m_41503_(type.getDurability(material)));
        this.type = type;
        this.attackDamage = CombatHelper.getBaseAttackDamage(material, type);
        this.attackSpeed = CombatHelper.getBaseAttackSpeed(material, type);
        this.decreasedAttackDamage = CombatHelper.getDecreasedAttackDamage(this.attackDamage, type);
        this.decreasedAttackSpeed = CombatHelper.getDecreasedAttackSpeed(this.attackSpeed, type);
        if (material.equals(ModItemTier.SILVER)) {
            this.isSilver = true;
            this.silverAttackDamage = CombatHelper.getSilverAttackDamage(material, type);
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean onAttackClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!this.isLong()) {
            return true;
        }
        if (entity != player && entity != player.m_20202_()) {
            PacketLongReachAttack.sendToServer(entity.m_142049_());
        }
        player.m_36334_();
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, @NotNull EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return this.m_7167_(slot);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean selected) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            boolean flag = false;
            if (this.type.getTwoHanded() > 0 && !livingentity.m_21206_().m_41720_().equals(Items.f_41852_)) {
                if (this.getAttackDamage(stack) != this.decreasedAttackDamage) {
                    this.setAttackDamage(stack, this.decreasedAttackDamage);
                    flag = true;
                }
                if (this.getAttackSpeed(stack) != this.decreasedAttackSpeed) {
                    this.setAttackSpeed(stack, this.decreasedAttackSpeed);
                    flag = true;
                }
            } else {
                if (this.getAttackDamage(stack) != this.attackDamage) {
                    this.setAttackDamage(stack, this.attackDamage);
                    flag = true;
                }
                if (this.getAttackSpeed(stack) != this.attackSpeed) {
                    this.setAttackSpeed(stack, this.attackSpeed);
                    flag = true;
                }
            }
            if (flag) {
                ItemStack itemstack = ((LivingEntity)entity).m_21205_();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    livingentity.m_21204_().m_22161_(itemstack.m_41638_(slot));
                    livingentity.m_21204_().m_22178_(itemstack.m_41638_(slot));
                }
            }
            if (this.canBlock()) {
                this.blockingPriority = !(livingentity.m_21205_().m_41720_() instanceof ShieldItem) && !(livingentity.m_21206_().m_41720_() instanceof ShieldItem);
            }
        }
        super.m_6883_(stack, level, entity, i, selected);
    }

    public boolean onHurtEntity(DamageSource source, LivingEntity victim, float damage) {
        Entity entity;
        if (victim.f_19853_.m_5776_() || ModDamageSource.isAdditional(source) || !((entity = source.m_7639_()) instanceof LivingEntity)) {
            return true;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (this.type.isFlamebladed()) {
            LacerationEffect.apply(victim, damage);
        }
        if (this.type.isHalberd() && victim.m_20159_() && victim.f_19853_.m_5822_().nextInt(20) >= 14) {
            victim.m_8127_();
        }
        boolean flag = false;
        if (this.isSilver()) {
            flag = this.dealSilverDamage(attacker, victim, damage);
        }
        if (!flag && this.type.getArmorPiercing() != 0 && victim.m_21230_() > 0) {
            flag = this.dealArmorPiercingDamage(attacker, victim, damage);
        }
        return flag;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.isSilver) {
            tooltip.add((Component)new TextComponent("+" + this.getSilverDamage(stack, this.getAttackDamage(stack)) + " ").m_7220_((Component)new TranslatableComponent("silvertools.hurt")).m_130940_(ChatFormatting.GREEN));
        }
        if (this.type.isFlamebladed()) {
            tooltip.add((Component)new TranslatableComponent("flamebladed.hurt").m_130940_(ChatFormatting.BLUE));
        }
        if (this.type.isHalberd()) {
            tooltip.add((Component)new TranslatableComponent("halberd.hurt").m_130940_(ChatFormatting.BLUE));
        }
        if (this.type.getArmorPiercing() != 0) {
            tooltip.add((Component)new TextComponent(this.type.getArmorPiercing() + "% ").m_7220_((Component)new TranslatableComponent("armorpiercing")).m_130940_(ChatFormatting.BLUE));
        }
        if (this.isLong()) {
            tooltip.add((Component)new TextComponent("+" + this.type.getBonusAttackReach() + " ").m_7220_((Component)new TranslatableComponent("bonusattackreach")).m_130940_(ChatFormatting.BLUE));
        }
        if (this.type.getTwoHanded() == 1) {
            tooltip.add((Component)new TranslatableComponent("twohandedi").m_130940_(ChatFormatting.BLUE));
        } else if (this.type.getTwoHanded() > 1) {
            tooltip.add((Component)new TranslatableComponent("twohandedii").m_130940_(ChatFormatting.BLUE));
        }
        if (this.canBlock()) {
            tooltip.add((Component)new TextComponent(this.getMaxBlockDamage() + " ").m_7220_((Component)new TranslatableComponent("maxdamageblock")).m_130940_(ChatFormatting.BLUE));
        }
        tooltip.add((Component)new TextComponent("" + this.getWeight()).m_7220_((Component)new TranslatableComponent("kgweight")).m_130940_(ChatFormatting.BLUE));
        if (this.hasTwoHandedPenalty(stack)) {
            tooltip.add((Component)new TranslatableComponent("twohandedpenalty_1").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TranslatableComponent("twohandedpenalty_2").m_130940_(ChatFormatting.RED));
        }
    }

    public float getAttackDamage(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("currentAttackDamage")) {
            return nbt.m_128457_("currentAttackDamage");
        }
        return this.attackDamage;
    }

    public float getAttackSpeed(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("currentAttackSpeed")) {
            return nbt.m_128457_("currentAttackSpeed");
        }
        return this.attackSpeed;
    }

    public void setAttackDamage(ItemStack stack, float attackdamage) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128350_("currentAttackDamage", attackdamage);
        stack.m_41751_(nbt);
    }

    public void setAttackSpeed(ItemStack stack, float attackspeed) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128350_("currentAttackSpeed", attackspeed);
        stack.m_41751_(nbt);
    }

    public float m_43299_() {
        return this.attackDamage;
    }

    public float getAttackReach(float baseReach) {
        return baseReach + this.getBonusAttackReach();
    }

    public float getBonusAttackReach() {
        return KnightlyArmory.BC_or_EF_installed ? 0.0f : this.type.getBonusAttackReach();
    }

    public boolean isLong() {
        return (double)this.getBonusAttackReach() > 0.0;
    }

    public float getSilverDamage(ItemStack stack, float damage) {
        return this.silverAttackDamage * damage / this.getAttackDamage(stack);
    }

    public float getMaxBlockDamage() {
        return this.type.getMaxBlockDamage();
    }

    public float getWeight() {
        return this.type.getWeight();
    }

    public boolean isSilver() {
        return this.isSilver;
    }

    public boolean canBlock(Player player) {
        return player.m_36403_(0.0f) == 1.0f && this.canBlock();
    }

    public boolean canBlock() {
        return this.type.canBlock();
    }

    boolean haveBlocked(Random rand, DamageSource source) {
        return !source.m_19360_() && (float)rand.nextInt(18) > this.getWeight();
    }

    public boolean hasTwoHandedPenalty(ItemStack stack) {
        return this.type.getTwoHanded() > 0 && this.getAttackSpeed(stack) == this.decreasedAttackSpeed;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (this.canBlock(player) && this.blockingPriority) {
            ItemStack stack = player.m_21120_(hand);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public int m_8105_(ItemStack stack) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.canBlock() && this.blockingPriority ? UseAnim.BLOCK : super.m_6164_(stack);
    }

    public void onBlocked(ItemStack stack, float damage, LivingEntity victim, DamageSource source) {
        if (!this.canBlock() || ModDamageSource.isAdditional(source)) {
            return;
        }
        Entity attacker = source.m_7639_();
        float f = CombatHelper.getArmorPiercingFactor(attacker);
        if (source.m_19372_()) {
            victim.m_6469_(ModDamageSource.additional(), damage);
        } else if (!this.haveBlocked(victim.f_19853_.m_5822_(), source)) {
            victim.m_6469_(ModDamageSource.additional(), damage);
        } else if (damage > this.getMaxBlockDamage()) {
            f *= 1.5f;
            float damage1 = damage - this.getMaxBlockDamage();
            victim.m_6469_(ModDamageSource.additional(), damage1);
        }
        stack.m_41622_((int)(f * damage), victim, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
    }

    public boolean dealSilverDamage(LivingEntity attacker, LivingEntity victim, float damage) {
        if (victim.m_6336_().equals(MobType.f_21641_)) {
            victim.m_6469_((DamageSource)ModDamageSource.silverAttack((Entity)attacker), damage + this.getSilverDamage(attacker.m_21205_(), damage));
            return true;
        }
        return false;
    }

    public boolean dealArmorPiercingDamage(LivingEntity attacker, LivingEntity victim, float damage) {
        float afterabsorb = CombatRules.m_19272_((float)damage, (float)victim.m_21230_(), (float)((float)victim.m_21133_(Attributes.f_22285_)));
        afterabsorb = Math.max(afterabsorb - victim.m_6103_(), 0.0f);
        float pierced = Math.max((float)this.type.getArmorPiercing() / 100.0f * (damage - afterabsorb), 0.0f);
        victim.m_6469_((DamageSource)ModDamageSource.armorPiercing((Entity)attacker), afterabsorb + pierced);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        if (this.canBlock()) {
            ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("blocking"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        }
    }
}

