/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advancement.trigger;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoACycleTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation triggerId = new ResourceLocation("aoa3", "cycle");

    public ResourceLocation m_7295_() {
        return triggerId;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext conditions) {
        ResourceLocation skillId;
        AoASkill skill = null;
        if (json.has("skill") && (skill = AoASkills.getSkill(skillId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"skill")))) == null) {
            throw new IllegalArgumentException("Invalid AoASkill ID: '" + skillId + "'");
        }
        int trigger = json.has("cycle") ? Mth.m_14045_((int)GsonHelper.m_13927_((JsonObject)json, (String)"cycle"), (int)1, (int)10) : 0;
        return new Instance(skill, trigger);
    }

    public void trigger(ServerPlayer player, AoASkill skill, int level) {
        this.m_66234_(player, instance -> instance.test(skill, level));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final AoASkill skill;
        private final int cycle;

        public Instance(@Nullable AoASkill skill, int cycle, EntityPredicate.Composite playerPredicate) {
            super(triggerId, playerPredicate);
            this.skill = skill;
            this.cycle = Mth.m_14045_((int)cycle, (int)1, (int)10);
        }

        public Instance(@Nullable AoASkill skill, int cycle) {
            this(skill, cycle, EntityPredicate.Composite.f_36667_);
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject obj = super.m_7683_(conditions);
            if (this.skill != null) {
                obj.addProperty("skill", this.skill.getRegistryName().toString());
            }
            if (this.cycle > 0) {
                obj.addProperty("cycle", (Number)this.cycle);
            }
            return obj;
        }

        public boolean test(AoASkill skill, int level) {
            return !(this.skill != null && this.skill != skill || this.cycle != 0 && level < this.cycle);
        }
    }
}

