/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advancement.trigger;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoAXpGainTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation triggerId = new ResourceLocation("aoa3", "gain_xp");

    public ResourceLocation m_7295_() {
        return triggerId;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext conditions) {
        ResourceLocation skillId;
        AoASkill skill = null;
        if (json.has("skill") && (skill = AoARegistries.AOA_SKILLS.getEntry(skillId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"skill")))) == null) {
            throw new IllegalArgumentException("Invalid AoASkill ID: '" + skillId + "'");
        }
        float xp = json.has("xp") ? GsonHelper.m_13915_((JsonObject)json, (String)"xp") : 0.0f;
        return new Instance(skill, xp);
    }

    public void trigger(ServerPlayer player, AoASkill skill, float xp) {
        this.m_66234_(player, instance -> instance.test(skill, xp));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final AoASkill skill;
        private final float xp;

        public Instance(@Nullable AoASkill skill, float xp, EntityPredicate.Composite playerPredicate) {
            super(triggerId, playerPredicate);
            this.skill = skill;
            this.xp = xp;
        }

        public Instance(@Nullable AoASkill skill, float xp) {
            this(skill, xp, EntityPredicate.Composite.f_36667_);
        }

        public boolean test(AoASkill skill, float xp) {
            return !(this.skill != null && this.skill != skill || this.xp != 0.0f && !(this.xp <= xp));
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject obj = super.m_7683_(conditions);
            if (this.skill != null) {
                obj.addProperty("skill", this.skill.getRegistryName().toString());
            }
            if (this.xp > 0.0f) {
                obj.addProperty("xp", (Number)Float.valueOf(this.xp));
            }
            return obj;
        }
    }
}

