/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.AoAEntityRendering;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.event.ClientEventHandler;
import net.tslat.aoa3.client.gui.hud.BossBarRenderer;
import net.tslat.aoa3.client.gui.hud.HealthStatusRenderer;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.client.gui.overlay.ScreenOverlayRenderer;
import net.tslat.aoa3.client.model.ModelProperties;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.CustomDimensionRenders;
import net.tslat.aoa3.client.render.entity.misc.OccultBlockRenderer;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.command.argument.AoAResourceArgument;
import net.tslat.aoa3.command.argument.AoASkillArgument;
import net.tslat.aoa3.command.argument.StructureIdArgument;
import net.tslat.aoa3.common.misc.NativePatching;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoADispensables;
import net.tslat.aoa3.common.registration.AoAEntityData;
import net.tslat.aoa3.common.registration.AoAEntitySpawns;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.content.capability.CapabilitiesManager;
import net.tslat.aoa3.content.capability.adventplayer.AdventPlayerCapabilityHandles;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.data.server.AoAHaulingFishReloadListener;
import net.tslat.aoa3.data.server.AoAResourcesReloadListener;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.data.server.AoASkillsReloadListener;
import net.tslat.aoa3.event.AoAPlayerEvents;
import net.tslat.aoa3.event.EntityEvents;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.event.PlayerEvents;
import net.tslat.aoa3.event.RestrictionEventHandler;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WebUtil;
import software.bernie.aoa3.geckolib3.GeckoLib;

@Mod(value="aoa3")
public class AdventOfAscension {
    public static final String VERSION = "1.18.2-3.6.6";
    public static final String MOD_ID = "aoa3";
    public static final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    public AdventOfAscension() {
        Logging.logStatusMessage("!~ Advent of Ascension v1.18.2-3.6.6 ~!");
        AdventOfAscension.initEventHandlers();
        GeckoLib.initialize();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> AoAEntityRendering::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEventHandler::init);
        NativePatching.doEarlyPatches();
        AoAAdvancementTriggers.registerTriggers();
        AoARegistries.init();
        IntegrationManager.preInit();
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve(MOD_ID), (String)MOD_ID);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)AoAConfig.SERVER_CONFIG_SPEC, "aoa3_server_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AoAConfig.COMMON_CONFIG_SPEC, MOD_ID + File.separator + "common_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AoAConfig.CLIENT_CONFIG_SPEC, MOD_ID + File.separator + "client_config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AoAConfig.INTEGRATIONS_CONFIG_SPEC, MOD_ID + File.separator + "integrations_config.toml");
    }

    private static void commonSetup(FMLCommonSetupEvent ev) {
        AoAGameRules.registerGameRules(ev);
        AoAPackets.registerPackets();
        AoAEntitySpawns.registerEntitySpawns();
        ev.enqueueWork(AoADispensables::registerDispenseBehaviours);
        AoAEntityData.init();
        PlayerUtil.init();
        ArgumentTypes.m_121601_((String)"structure", StructureIdArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(StructureIdArgument::new));
        ArgumentTypes.m_121601_((String)"aoa3:skill", AoASkillArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(AoASkillArgument::new));
        ArgumentTypes.m_121601_((String)"aoa3:resource", AoAResourceArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(AoAResourceArgument::new));
        ev.enqueueWork(NativePatching::postInit);
        ev.enqueueWork(IntegrationManager::postInit);
    }

    private static void clientSetup(FMLClientSetupEvent ev) {
        AoABlocks.setCustomRenderTypes();
        AoAKeybinds.registerKeybinds();
        AoABlockEntities.registerRenderers();
        AoAContainers.registerContainerScreens();
        ModelProperties.init();
        CustomDimensionRenders.init();
        AoAKeybinds.init();
        BossBarRenderer.init();
        RecoilRenderer.init();
        XpParticlesRenderer.init();
        ScreenOverlayRenderer.init();
        HealthStatusRenderer.init();
        ScopeOverlayRenderer.init();
        AoAGuiElementRenderers.init();
        OccultBlockRenderer.init();
    }

    private static void loadFinished(FMLLoadCompleteEvent ev) {
        WebUtil.doHTTPTasks();
    }

    private static void registerCommands(RegisterCommandsEvent ev) {
        AoACommand.registerSubCommands((CommandDispatcher<CommandSourceStack>)ev.getDispatcher());
    }

    private static void initEventHandlers() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(EventPriority.NORMAL, false, NewRegistryEvent.class, AdventOfAscension::setupRegistries);
        modEventBus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, AdventOfAscension::commonSetup);
        modEventBus.addListener(EventPriority.NORMAL, false, FMLClientSetupEvent.class, AdventOfAscension::clientSetup);
        modEventBus.addListener(EventPriority.NORMAL, false, FMLLoadCompleteEvent.class, AdventOfAscension::loadFinished);
        modEventBus.addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, AdventOfAscension::registerCapabilities);
        forgeBus.addListener(EventPriority.NORMAL, false, RegisterCommandsEvent.class, AdventOfAscension::registerCommands);
        forgeBus.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, AdventOfAscension::customDatapackLoaders);
        RestrictionEventHandler.preInit();
        PlayerEvents.preInit();
        GlobalEvents.preInit();
        EntityEvents.preInit();
        CapabilitiesManager.preInit();
        AoAEntitySpawns.preInit();
        AoAPlayerEvents.preInit();
        AoAEntityData.preInit();
    }

    private static void setupRegistries(NewRegistryEvent ev) {
        ev.create(new RegistryBuilder().setName(AdventOfAscension.id("abilities")).setType(AoAAbility.class).setMaxID(0x7FFFFFFE).disableSaving());
        ev.create(new RegistryBuilder().setName(AdventOfAscension.id("resources")).setType(AoAResource.class).setMaxID(0x7FFFFFFE).disableSaving());
        ev.create(new RegistryBuilder().setName(AdventOfAscension.id("skills")).setType(AoASkill.class).setMaxID(0x7FFFFFFE).disableSaving());
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent ev) {
        ev.register(AdventPlayerCapabilityHandles.class);
        ev.register(VolatileStackCapabilityHandles.class);
        ev.register(PersistentStackCapabilityHandles.class);
    }

    private static void customDatapackLoaders(AddReloadListenerEvent ev) {
        ev.addListener((PreparableReloadListener)new AoAResourcesReloadListener());
        ev.addListener((PreparableReloadListener)new AoASkillReqReloadListener());
        ev.addListener((PreparableReloadListener)new AoASkillsReloadListener());
        ev.addListener((PreparableReloadListener)new AoAHaulingFishReloadListener());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

