/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.container.BankerContainer;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RenderUtil;

public class BankerScreen
extends AbstractContainerScreen<BankerContainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("aoa3", "textures/gui/containers/banker.png");
    private final Minecraft mc;

    public BankerScreen(BankerContainer container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
        this.f_97727_ = 187;
        this.mc = Minecraft.m_91087_();
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int centerX = (this.f_96543_ - this.f_97726_) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.prepRenderTexture(guiTexture);
        RenderUtil.renderCustomSizedTexture(matrix, centerX, centerY, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256.0f, 256.0f);
        if (this.mc.f_91074_ != null) {
            this.renderCoinPlaceholders(matrix, centerX, centerY);
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        int titleWidth = 4 + this.mc.f_91062_.m_92852_((FormattedText)this.f_96539_);
        RenderUtil.resetShaderColour();
        RenderUtil.prepRenderTexture(guiTexture);
        RenderUtil.renderCustomSizedTexture(matrix, 28, 4, 176.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        for (int i = 0; i < titleWidth - 2; ++i) {
            RenderUtil.renderCustomSizedTexture(matrix, 29 + i, 4, 177.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        }
        RenderUtil.renderCustomSizedTexture(matrix, 28 + titleWidth - 2, 4, 178.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        RenderUtil.resetShaderColour();
        this.mc.f_91062_.m_92889_(matrix, this.f_96539_, 30.0f, 6.0f, ColourUtil.WHITE);
    }

    private void renderCoinPlaceholders(PoseStack matrix, int centerX, int centerY) {
        for (int i = 0; i < 12; ++i) {
            boolean diffuseLighting;
            Slot slot = ((BankerContainer)this.f_97732_).m_38853_(i);
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) continue;
            ItemStack coinStack = new ItemStack((ItemLike)BankerContainer.getCoinForSlot(i), i < 3 || i > 8 ? 20 : 1);
            BakedModel model = this.mc.m_91291_().m_174264_(coinStack, null, null, 0);
            matrix.m_85836_();
            RenderUtil.prepRenderTexture(InventoryMenu.f_39692_);
            this.mc.f_90987_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.m_69478_();
            RenderUtil.setDefaultAlphaBlend();
            RenderUtil.resetShaderColour();
            matrix.m_85837_((double)(slot.f_40220_ + centerX), (double)(slot.f_40221_ + centerY), 100.0);
            matrix.m_85837_(8.0, 8.0, 0.0);
            matrix.m_85841_(1.0f, -1.0f, 1.0f);
            matrix.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = diffuseLighting = !model.m_7547_();
            if (diffuseLighting) {
                Lighting.m_84930_();
            }
            this.mc.m_91291_().m_115143_(coinStack, ItemTransforms.TransformType.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 1000, OverlayTexture.f_118083_, model);
            renderTypeBuffer.m_109911_();
            RenderSystem.m_69482_();
            if (diffuseLighting) {
                Lighting.m_84931_();
            }
            matrix.m_85849_();
            this.mc.m_91291_().m_115169_(this.mc.f_91062_, coinStack, slot.f_40220_ + centerX, slot.f_40221_ + centerY);
        }
    }
}

