/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.util.RenderUtil;

public final class ScopeOverlayRenderer {
    public static boolean isScoped = false;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventPriority.NORMAL, false, FOVModifierEvent.class, ScopeOverlayRenderer::onFOVUpdate);
        bus.addListener(EventPriority.NORMAL, false, RenderHandEvent.class, ScopeOverlayRenderer::onHandRender);
        bus.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.PreLayer.class, ScopeOverlayRenderer::beforeOverlayRender);
        bus.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.PostLayer.class, ScopeOverlayRenderer::afterOverlayRender);
    }

    private static void onFOVUpdate(FOVModifierEvent event) {
        if (isScoped && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            event.setNewfov(0.2f);
        }
    }

    private static void onHandRender(RenderHandEvent event) {
        if (isScoped && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            event.setCanceled(true);
        }
    }

    private static void beforeOverlayRender(RenderGameOverlayEvent.PreLayer event) {
        if (isScoped && event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            event.setCanceled(true);
        }
    }

    private static void afterOverlayRender(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay() != ForgeIngameGui.HELMET_ELEMENT || Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation texture = null;
        if (mc.f_91074_.m_6144_() && mc.f_91074_.m_20096_()) {
            ItemStack sniper = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (sniper.m_41720_() instanceof BaseSniper) {
                isScoped = true;
                texture = ((BaseSniper)sniper.m_41720_()).getScopeTexture(sniper);
            } else {
                isScoped = false;
            }
        } else {
            isScoped = false;
        }
        if (!isScoped) {
            return;
        }
        RenderSystem.m_157456_((int)0, texture);
        RenderUtil.renderFullscreenTexture();
    }
}

