/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class HaulingBobberRenderer
extends FishingHookRenderer {
    private final ResourceLocation texture;
    private final RenderType renderType;

    public HaulingBobberRenderer(EntityRendererProvider.Context rendererManager) {
        this(rendererManager, new ResourceLocation("textures/entity/fishing_hook.png"));
    }

    public HaulingBobberRenderer(EntityRendererProvider.Context renderManager, ResourceLocation texture) {
        super(renderManager);
        this.texture = texture;
        this.renderType = RenderType.m_110452_((ResourceLocation)texture);
    }

    public void m_7392_(FishingHook bobber, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        float eyeHeight;
        double startZ;
        double startY;
        double startX;
        Player player = bobber.m_37168_();
        if (player == null) {
            return;
        }
        matrix.m_85836_();
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        matrix.m_85845_(this.f_114476_.m_114470_());
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        PoseStack.Pose lastPose = matrix.m_85850_();
        Matrix4f lastPose4f = lastPose.m_85861_();
        Matrix3f lastPoseNormal = lastPose.m_85864_();
        VertexConsumer vertexConsumer = buffer.m_6299_(this.renderType);
        HaulingBobberRenderer.vertex(vertexConsumer, lastPose4f, lastPoseNormal, packedLight, 0.0f, 0, 0, 1);
        HaulingBobberRenderer.vertex(vertexConsumer, lastPose4f, lastPoseNormal, packedLight, 1.0f, 0, 1, 1);
        HaulingBobberRenderer.vertex(vertexConsumer, lastPose4f, lastPoseNormal, packedLight, 1.0f, 1, 1, 0);
        HaulingBobberRenderer.vertex(vertexConsumer, lastPose4f, lastPoseNormal, packedLight, 0.0f, 1, 0, 0);
        matrix.m_85849_();
        int sideMod = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof FishingRodItem)) {
            sideMod = -sideMod;
        }
        float swingTime = player.m_21324_(partialTicks);
        float swingAngle = Mth.m_14031_((float)(Mth.m_14116_((float)swingTime) * (float)Math.PI));
        float bodyRot = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
        double sinRot = Mth.m_14031_((float)bodyRot);
        double cosRot = Mth.m_14089_((float)bodyRot);
        double sideMod2 = (double)sideMod * 0.35;
        if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
            double fovScale = 960.0 / this.f_114476_.f_114360_.f_92068_;
            Vec3 firstPersonStartPos = this.f_114476_.f_114358_.m_167684_().m_167695_((float)sideMod * 0.525f, -0.1f);
            firstPersonStartPos = firstPersonStartPos.m_82490_(fovScale);
            firstPersonStartPos = firstPersonStartPos.m_82524_(swingAngle * 0.5f);
            firstPersonStartPos = firstPersonStartPos.m_82496_(-swingAngle * 0.7f);
            startX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + firstPersonStartPos.f_82479_;
            startY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + firstPersonStartPos.f_82480_;
            startZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + firstPersonStartPos.f_82481_;
            eyeHeight = player.m_20192_();
        } else {
            startX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - cosRot * sideMod2 - sinRot * 0.8;
            startY = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
            startZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - sinRot * sideMod2 + cosRot * 0.8;
            eyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
        }
        double bobberX = Mth.m_14139_((double)partialTicks, (double)bobber.f_19854_, (double)bobber.m_20185_());
        double bobberY = Mth.m_14139_((double)partialTicks, (double)bobber.f_19855_, (double)bobber.m_20186_()) + 0.25;
        double bobberZ = Mth.m_14139_((double)partialTicks, (double)bobber.f_19856_, (double)bobber.m_20189_());
        float distX = (float)(startX - bobberX);
        float distY = (float)(startY - bobberY) + eyeHeight;
        float distZ = (float)(startZ - bobberZ);
        vertexConsumer = buffer.m_6299_(RenderType.m_173247_());
        lastPose = matrix.m_85850_();
        for (int section = 0; section <= 16; ++section) {
            HaulingBobberRenderer.stringVertex(distX, distY, distZ, vertexConsumer, lastPose, (float)section / 16.0f, (float)(section + 1) / 16.0f);
        }
        matrix.m_85849_();
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)bobber, bobber.m_5446_(), (EntityRenderer)this, matrix, buffer, packedLight, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Entity)bobber))) {
            this.m_7649_((Entity)bobber, renderNameplateEvent.getContent(), matrix, buffer, packedLight);
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrixPos, Matrix3f matrixNormal, int packedLight, float x, int y, int u, int v) {
        vertexConsumer.m_85982_(matrixPos, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float lengthX, float lengthY, float lengthZ, VertexConsumer vertexConsumer, PoseStack.Pose pose, float sectionStart, float sectionEnd) {
        float x = lengthX * sectionStart;
        float y = lengthY * (sectionStart * sectionStart + sectionStart) * 0.5f + 0.25f;
        float z = lengthZ * sectionStart;
        float xNormalised = lengthX * sectionEnd - x;
        float yNormalised = lengthY * (sectionEnd * sectionEnd + sectionEnd) * 0.5f + 0.25f - y;
        float zNormalised = lengthZ * sectionEnd - z;
        float hypot = Mth.m_14116_((float)(xNormalised * xNormalised + yNormalised * yNormalised + zNormalised * zNormalised));
        vertexConsumer.m_85982_(pose.m_85861_(), x, y, z).m_6122_(0, 0, 0, 255).m_85977_(pose.m_85864_(), xNormalised /= hypot, yNormalised /= hypot, zNormalised /= hypot).m_5752_();
    }

    public ResourceLocation m_5478_(FishingHook bobber) {
        return this.texture;
    }
}

