/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAEntityData;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.base.AbstractLavaFishEntity;
import net.tslat.aoa3.content.world.spawner.PixonSpawner;
import net.tslat.aoa3.content.world.spawner.TraderSpawner;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class AoAEntitySpawns {
    private static final ArrayList<SpawnEntry> SPAWN_ENTRIES = new ArrayList();

    public static void preInit() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, false, BiomeLoadingEvent.class, AoAEntitySpawns::onBiomeLoad);
    }

    public static void registerEntitySpawns() {
        Logging.logStatusMessage("Registering entity spawns");
        AoAEntitySpawns.populateOverworldSpawnEntries();
    }

    public static void populateOverworldSpawnEntries() {
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.ICE_GIANT.get()), 1).groupSize(-50, 1).matchBiomes(BiomeDictionary.Type.SNOWY).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.LEAFY_GIANT.get()), 1).groupSize(-50, 1).matchBiomes(BiomeDictionary.Type.CONIFEROUS).ignoreBiomes(BiomeDictionary.Type.SNOWY).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.STONE_GIANT.get()), 1).groupSize(-50, 1).matchBiomes(BiomeDictionary.Type.MOUNTAIN).ignoreBiomes(BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.LUSH).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.SHINY_SQUID.get()), 1).groupSize(-1000, 1).matchBiomes(BiomeDictionary.Type.OCEAN).place(SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)GlowSquid::m_186001_));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.BLUE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CANDLEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CHARRED_CHAR.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CHOCAW.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.DARK_HATCHETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.GREEN_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.HYDRONE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.IRONBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.JAMFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PARAPIRANHA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RAINBOWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RAZORFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RED_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.REEFTOOTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.ROCKETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SAILBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SKELECANTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.WHITE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.VIOLET_SKIPPER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
    }

    private static void setAbyssSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ANEMIA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.APPARITION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BLOODSUCKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DISTORTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FIEND.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.OCCULENT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.WEB_REAPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "abyssal_plains")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.SHINING_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "abyssal_plains")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true)).specialSpawner(PixonSpawner::addSpawn);
    }

    public static void setBarathosSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ARKBACK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CRYPTID.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ECHODAR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.EMPEROR_BEAST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.KEELER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.NOSPIKE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.PARASECT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.RAMRADON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SQUIGGLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.THARAFLY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "barren_grounds")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setCandylandSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PEPPERMINT_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SPEARMINT_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.AIRHEAD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CANDY_CORNY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CHERRY_BLASTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.LOLLYPOPPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "candy_hills")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setCeleveSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BOBO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CHOCKO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.JUMBO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.KOKO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.KRANKY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.HAPPY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SNAPPY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.STICKY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.STITCHES.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.TIPSY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "celevian_highlands")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setCreeponiaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CREEP_COW.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BONE_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CAVE_CREEPOID.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CREEPERLOCK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CREEPIRD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CREEPUPLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.HOST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.KING_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.MAGICAL_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.WINGED_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "creepoid_forest")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setCrysteviaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_FLIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_MIND.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_RANGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_RESISTANCE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_SPEED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_STRENGTH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CONSTRUCT_OF_TERROR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "crystevian_caverns")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setDeeplandsSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SHIK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate((TagKey<Block>)Tags.Blocks.STONE, true));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CASE_CONSTRUCT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CAVE_CREEP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DOUBLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DWELLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ROCKBITER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ROCK_CRAWLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ROCK_CRITTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "cavern_depths")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setDustopiaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.URKA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BASILISK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DEVOURER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DUSTEIVA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DUSTON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.LOST_SOUL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.LURKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.STALKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.RADIANT_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "dustopian_forest")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true)).specialSpawner(PixonSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "dustopian_forest")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setGardenciaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ARCHVINE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BROCCOHEAD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CARROTOP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CORNY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FLOWERFACE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SQUASHER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SUNNY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "floral_islands")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setGreckonSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.GRILLFACE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.HUNTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SHIFTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SILENCER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SKULL_CREATURE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SUGARFACE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.VALKYRIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "greckon_mountains")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setHavenSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.ANGELICA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.DAWNLIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.EEO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.HALYCON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RAINICORN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.VOLIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "haven")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setIromineSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.MECHACHRON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.MECHAMATON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.POLYTOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.VOLTRON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.METALLOID.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "iromine")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "iromine")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void populateNetherSpawnEntries() {
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.EMBRAKE.get()), 60).matchBiomes(BiomeDictionary.Type.NETHER).ignoreExactBiomes(new ResourceLocation("basalt_deltas"), new ResourceLocation("warped_forest"), new ResourceLocation("soul_sand_valley")).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.FLAMEWALKER.get()), 60).matchBiomes(BiomeDictionary.Type.NETHER).ignoreExactBiomes(new ResourceLocation("basalt_deltas"), new ResourceLocation("warped_forest"), new ResourceLocation("soul_sand_valley")).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.INFERNAL.get()), 10).matchBiomes(BiomeDictionary.Type.NETHER).ignoreExactBiomes(new ResourceLocation("basalt_deltas"), new ResourceLocation("warped_forest"), new ResourceLocation("soul_sand_valley")).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.SKELETAL_COWMAN.get()), 45).matchBiomes(BiomeDictionary.Type.NETHER).ignoreExactBiomes(new ResourceLocation("basalt_deltas"), new ResourceLocation("warped_forest")).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAMobs.SCRUBBY.get()), 30).groupSize(1, 3).matchBiomes(BiomeDictionary.Type.NETHER).ignoreExactBiomes(new ResourceLocation("basalt_deltas"), new ResourceLocation("warped_forest"), new ResourceLocation("soul_sand_valley")).placeMonster();
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.LOTTOMAN.get()), 1).matchBiomes(BiomeDictionary.Type.NETHER).placeNPC().specialSpawner(TraderSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchBiomes(BiomeDictionary.Type.NETHER).placeNPC().specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setLboreanSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CORATEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(null, true));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ANGLER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.WATER_MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.MUNCHER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR, SpawnPredicates.WATER_MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.NEPTUNO.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.WATER_MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SEA_VIPER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.WATER_MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.GLOWING_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "coral_fields")).place(SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR, SpawnPredicates.animalPredicate(null, true)).specialSpawner(PixonSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "coral_fields")).place(SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setLelyetiaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.TROTTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FLYE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.GROBBLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.LELYETIAN_CASTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.LELYETIAN_WARRIOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.TRACKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.GLARING_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "lelyetian_plains")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false)).specialSpawner(PixonSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "lelyetian_plains")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void populateLunalusSpawnEntries() {
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "asteroid_belt")).placeNPC().specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setMysteriumSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FUNGAT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FUNGBACK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FUNGIK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FUNGUNG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.BLOOMING_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "fungal_caverns")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true)).specialSpawner(PixonSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "fungal_caverns")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setPrecasiaSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.MEGANEUROPSIS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DEINOTHERIUM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DYREHORN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.GIANT_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SABRETOOTH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.TERRADON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.TORTIONE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "precasian_tall_forest")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setRunandorSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ARIEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.BOUNCER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.PALADIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.RUNICORN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.RUNICORN_RIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoAAnimals.GLEAMING_PIXON.get()), 12).matchExactBiomes(new ResourceLocation("aoa3", "runic_cliffs")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, false)).specialSpawner(PixonSpawner::addSpawn);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "runic_cliffs")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setShyrelandsSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ARCBEAST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ARC_FLOWER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.AXIOLIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.OMNILIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SHYRE_KNIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SOULVYRE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SOULSCORNE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.STIMULO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.STIMULOSUS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SYSKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "shyre_remnants")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false)).specialSpawner(TraderSpawner::addSpawn);
    }

    public static void setVoxPondsSpawnPlacements() {
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.NIGHT_WATCHER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.animalPredicate(AoATags.Blocks.GRASS, true));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.ALARMO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.CENTINEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.DESTRUCTOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.FISCHER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.WATER_MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.GADGETOID.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.SLIMER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAMobs.TOXXULOUS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        new SpawnEntry((EntityType<? extends Mob>)((EntityType)AoANpcs.UNDEAD_HERALD.get()), 1).matchExactBiomes(new ResourceLocation("aoa3", "vox_wastes")).place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(true)).specialSpawner(TraderSpawner::addSpawn);
    }

    private static void onBiomeLoad(BiomeLoadingEvent ev) {
        if (ev.getName() == null) {
            return;
        }
        ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ev.getName());
        for (SpawnEntry entry : SPAWN_ENTRIES) {
            if (!entry.shouldSpawnInBiome((ResourceKey<Biome>)biomeKey)) continue;
            MobSpawnSettings.SpawnerData spawnData = new MobSpawnSettings.SpawnerData(entry.entityType, entry.weight, entry.minGroupSize, entry.maxGroupSize);
            if (entry.specialSpawnerConsumer != null) {
                entry.specialSpawnerConsumer.accept((ResourceKey<Biome>)biomeKey, spawnData);
                continue;
            }
            ev.getSpawns().getSpawner(entry.entityType.m_20674_()).add(spawnData);
        }
    }

    private static <T extends Mob> void setSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type placementType, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<? extends Mob> spawnPredicate) {
        try {
            if (SpawnPlacements.m_21752_(entityType) == SpawnPlacements.Type.NO_RESTRICTIONS) {
                SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)placementType, (Heightmap.Types)heightmap, spawnPredicate);
            }
        }
        catch (IllegalStateException ex) {
            Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Caught duplicate spawn placement registration from: " + entityType.getRegistryName().toString());
        }
    }

    public static class SpawnEntry {
        private final EntityType<? extends Mob> entityType;
        private final int weight;
        private int minGroupSize = 1;
        private int maxGroupSize = 1;
        @Nullable
        private HashSet<BiomeDictionary.Type> matchingBiomeTypes = null;
        @Nullable
        private HashSet<BiomeDictionary.Type> blacklistedBiomeTypes = null;
        @Nullable
        private HashSet<ResourceKey<Biome>> matchingBiomes = null;
        @Nullable
        private HashSet<ResourceKey<Biome>> ignoringBiomes = null;
        @Nullable
        private BiConsumer<ResourceKey<Biome>, MobSpawnSettings.SpawnerData> specialSpawnerConsumer = null;

        public SpawnEntry(EntityType<? extends Mob> entityType, int weight) {
            this.entityType = entityType;
            this.weight = weight;
            SPAWN_ENTRIES.add(this);
        }

        public EntityType<? extends Mob> getEntityType() {
            return this.entityType;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getMinGroupSize() {
            return this.minGroupSize;
        }

        public int getMaxGroupSize() {
            return this.maxGroupSize;
        }

        public HashSet<BiomeDictionary.Type> getMatchingBiomeTypes() {
            return this.matchingBiomeTypes;
        }

        public HashSet<BiomeDictionary.Type> getBlacklistedBiomeTypes() {
            return this.blacklistedBiomeTypes;
        }

        public HashSet<ResourceKey<Biome>> getMatchingBiomes() {
            return this.matchingBiomes;
        }

        public HashSet<ResourceKey<Biome>> getIgnoredBiomes() {
            return this.ignoringBiomes;
        }

        public SpawnEntry groupSize(int minGroupSize, int maxGroupSize) {
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = Math.max(minGroupSize, maxGroupSize);
            return this;
        }

        private SpawnEntry matchBiomes(BiomeDictionary.Type ... biomeTypes) {
            this.matchingBiomeTypes = new HashSet<BiomeDictionary.Type>(Arrays.asList(biomeTypes));
            return this;
        }

        private SpawnEntry ignoreBiomes(BiomeDictionary.Type ... biomeTypes) {
            this.blacklistedBiomeTypes = new HashSet<BiomeDictionary.Type>(Arrays.asList(biomeTypes));
            return this;
        }

        private SpawnEntry matchExactBiomes(ResourceLocation ... biomeIds) {
            this.matchingBiomes = new HashSet();
            for (ResourceLocation id : biomeIds) {
                this.matchingBiomes.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)id));
            }
            return this;
        }

        private SpawnEntry ignoreExactBiomes(ResourceLocation ... biomeIds) {
            this.ignoringBiomes = new HashSet();
            for (ResourceLocation id : biomeIds) {
                this.ignoringBiomes.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)id));
            }
            return this;
        }

        private SpawnEntry specialSpawner(BiConsumer<ResourceKey<Biome>, MobSpawnSettings.SpawnerData> specialSpawnerConsumer) {
            this.specialSpawnerConsumer = specialSpawnerConsumer;
            return this;
        }

        private boolean shouldSpawnInBiome(ResourceKey<Biome> biomeKey) {
            if (this.matchingBiomes != null) {
                return this.matchingBiomes.contains(biomeKey);
            }
            if (this.ignoringBiomes != null && this.ignoringBiomes.contains(biomeKey)) {
                return false;
            }
            if (biomeKey == Biomes.f_48215_) {
                return false;
            }
            if (this.matchingBiomeTypes != null) {
                Set types = BiomeDictionary.getTypes(biomeKey);
                if (this.matchingBiomeTypes.contains(BiomeDictionary.Type.NETHER) ? !types.contains(BiomeDictionary.Type.NETHER) : !types.contains(BiomeDictionary.Type.OVERWORLD)) {
                    return false;
                }
                if (this.blacklistedBiomeTypes != null) {
                    for (BiomeDictionary.Type type : this.blacklistedBiomeTypes) {
                        if (!types.contains(type)) continue;
                        return false;
                    }
                }
                for (BiomeDictionary.Type type : this.matchingBiomeTypes) {
                    if (!types.contains(type)) continue;
                    return true;
                }
            }
            return false;
        }

        private SpawnEntry placeNPC() {
            return this.place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false));
        }

        private SpawnEntry placeMonster() {
            return this.place(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
        }

        private SpawnEntry place(SpawnPlacements.Type type, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<? extends Mob> spawnPredicate) {
            AoAEntitySpawns.setSpawnPlacement(this.entityType, type, heightmap, spawnPredicate);
            return this;
        }
    }

    private static final class SpawnPredicates {
        private static final SpawnPlacements.SpawnPredicate<Mob> MONSTER = (type, world, reason, pos, rand) -> {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            boolean isVanillaWorld = WorldUtil.isWorld(world, Level.f_46428_, Level.f_46429_);
            if (EntityUtil.isNaturalSpawnReason(reason)) {
                if (AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && !world.m_6042_().m_63967_() && !world.m_6018_().m_46461_() && isVanillaWorld) {
                    return false;
                }
                if (AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.containsKey(type) && pos.m_123342_() > AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.get(type)) {
                    return false;
                }
                if (!((Biome)world.m_204166_(pos).m_203334_()).getRegistryName().m_135827_().equals("aoa3") && !isVanillaWorld) {
                    return false;
                }
            }
            if (!Mob.m_21400_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand)) {
                return false;
            }
            if (!AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && isVanillaWorld) {
                return Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)rand);
            }
            return WorldUtil.getLightLevel(world, pos, true, false) <= RandomUtil.randomNumberUpTo(8);
        };
        private static final SpawnPlacements.SpawnPredicate<Mob> WATER_MONSTER = (type, world, reason, pos, rand) -> {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            boolean isVanillaWorld = WorldUtil.isWorld(world, Level.f_46428_, Level.f_46429_);
            if (EntityUtil.isNaturalSpawnReason(reason)) {
                if (world.m_6018_().m_46461_() ? !AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && !world.m_6042_().m_63967_() && isVanillaWorld : !world.m_6042_().m_63967_() && !world.m_6018_().m_46472_().m_135782_().m_135827_().equals("aoa3") && AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type)) {
                    return false;
                }
                if (AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.containsKey(type) && pos.m_123342_() > AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.get(type)) {
                    return false;
                }
                if (!((Biome)world.m_204166_(pos).m_203334_()).getRegistryName().m_135827_().equals("aoa3") && !isVanillaWorld) {
                    return false;
                }
            }
            if (!world.m_8055_(pos).m_60819_().m_76152_().m_205067_(FluidTags.f_13131_)) {
                return false;
            }
            if (!AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && isVanillaWorld) {
                return Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)rand);
            }
            return WorldUtil.getLightLevel(world, pos, true, false) <= RandomUtil.randomNumberUpTo(8);
        };
        private static final SpawnPlacements.SpawnPredicate<Mob> FISH = (type, world, reason, pos, rand) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);

        private SpawnPredicates() {
        }

        private static final SpawnPlacements.SpawnPredicate<Mob> npcPredicate(boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (!Mob.m_21400_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand)) {
                    return false;
                }
                return spawnsInDarkness || WorldUtil.getLightLevel(world, pos, false, false) >= 8;
            };
        }

        private static <T extends Mob> SpawnPlacements.SpawnPredicate<T> animalPredicate(@Nullable TagKey<Block> blockTag, boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (blockTag != null && !world.m_8055_(pos.m_7495_()).m_204336_(blockTag)) {
                    return false;
                }
                return spawnsInDarkness || world.m_45524_(pos, 0) >= 8;
            };
        }
    }
}

