/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.loottable.condition.BlockHasTag;
import net.tslat.aoa3.content.loottable.condition.HoldingItem;
import net.tslat.aoa3.content.loottable.condition.PlayerHasLevel;
import net.tslat.aoa3.content.loottable.condition.PlayerHasResource;
import net.tslat.aoa3.content.loottable.function.EnchantSpecific;
import net.tslat.aoa3.content.loottable.function.GrantSkillXp;

public final class AoALootOperations {

    public static final class LootConditions {
        public static final RegistryObject<LootItemConditionType> HOLDING_ITEM = LootConditions.register("holding_item", new HoldingItem.Serializer());
        public static final RegistryObject<LootItemConditionType> PLAYER_HAS_LEVEL = LootConditions.register("player_has_level", new PlayerHasLevel.Serializer());
        public static final RegistryObject<LootItemConditionType> PLAYER_HAS_RESOURCE = LootConditions.register("player_has_resource", new PlayerHasResource.Serializer());
        public static final RegistryObject<LootItemConditionType> HAS_BLOCK_TAG = LootConditions.register("has_block_tag", new BlockHasTag.Serializer());

        public static void init() {
        }

        private static RegistryObject<LootItemConditionType> register(String id, Serializer<? extends LootItemCondition> serializer) {
            return AoARegistries.LOOT_CONDITIONS.register(id, () -> new LootItemConditionType(serializer));
        }
    }

    public static final class LootFunctions {
        public static final RegistryObject<LootItemFunctionType> ENCHANT_SPECIFIC = LootFunctions.register("enchant_specific", (Serializer<? extends LootItemFunction>)new EnchantSpecific.Serializer());
        public static final RegistryObject<LootItemFunctionType> GRANT_SKILL_XP = LootFunctions.register("grant_skill_xp", (Serializer<? extends LootItemFunction>)new GrantSkillXp.Serializer());

        public static void init() {
        }

        private static RegistryObject<LootItemFunctionType> register(String id, Serializer<? extends LootItemFunction> serializer) {
            return AoARegistries.LOOT_FUNCTIONS.register(id, () -> new LootItemFunctionType(serializer));
        }
    }
}

