/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.particletype.FloatingItemFragmentParticleType;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;
import net.tslat.aoa3.common.registration.AoARegistries;

public final class AoAParticleTypes {
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> SPARKLER = AoAParticleTypes.registerParticle("sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> FLICKERING_SPARKLER = AoAParticleTypes.registerParticle("flickering_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> RAINBOW_SPARKLER = AoAParticleTypes.registerParticle("rainbow_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> LINGERING_SPARKLER = AoAParticleTypes.registerParticle("lingering_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<PortalFloaterParticleType.Data>> PORTAL_FLOATER = AoAParticleTypes.registerParticle("portal_floater", () -> new PortalFloaterParticleType(false));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> SWIRLY = AoAParticleTypes.registerParticle("swirly", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<ItemParticleOption>> FLOATING_ITEM_FRAGMENT = AoAParticleTypes.registerParticle("floating_item_fragment", () -> new FloatingItemFragmentParticleType(false));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> FREEZING_SNOWFLAKE = AoAParticleTypes.registerParticle("freezing_snowflake", () -> new CustomisableParticleType(true));

    public static void init() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, ParticleFactoryRegisterEvent.class, ClientOperations::registerParticleFactories));
    }

    private static <T extends ParticleOptions> RegistryObject<ParticleType<T>> registerParticle(String id, Supplier<? extends ParticleType<T>> particle) {
        return AoARegistries.PARTICLES.register(id, particle);
    }

    private static <T extends ParticleOptions> RegistryObject<ParticleType<T>> registerParticle(String id, ParticleOptions.Deserializer<T> deserializer, final Function<ParticleType<T>, Codec<T>> codecFunction) {
        return AoARegistries.PARTICLES.register(id, () -> new ParticleType<T>(false, deserializer){

            public Codec<T> m_7652_() {
                return (Codec)codecFunction.apply(this);
            }
        });
    }
}

